/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.Container;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.servlet.api.helpers.AbstractServletListener;
import org.slf4j.cal10n.LocLogger;

public class WeldListener
extends AbstractServletListener {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.SERVLET);
    private transient HttpSessionContext sessionContextCache;
    private transient HttpRequestContext requestContextCache;
    private transient HttpConversationContext conversationContextCache;
    private String contextId;

    private HttpSessionContext sessionContext(String id) {
        if (this.sessionContextCache == null) {
            this.sessionContextCache = (HttpSessionContext)Container.instance(id).deploymentManager().instance().select(HttpSessionContext.class, new Annotation[0]).get();
        }
        return this.sessionContextCache;
    }

    private HttpRequestContext requestContext(String id) {
        if (this.requestContextCache == null) {
            this.requestContextCache = (HttpRequestContext)Container.instance(id).deploymentManager().instance().select(HttpRequestContext.class, new Annotation[0]).get();
        }
        return this.requestContextCache;
    }

    private HttpConversationContext conversationContext(String id) {
        if (this.conversationContextCache == null) {
            this.conversationContextCache = (HttpConversationContext)Container.instance(id).deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
        }
        return this.conversationContextCache;
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.contextId == null) {
            this.contextId = event.getSession().getServletContext().getInitParameter("WELD_CONTEXT_ID_KEY");
        }
        if (this.contextId == null) {
            this.contextId = "STATIC_INSTANCE";
        }
        if (Container.available(this.contextId)) {
            this.sessionContext(this.contextId).destroy(event.getSession());
            RequestScopedBeanCache.endRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        if (this.contextId == null) {
            this.contextId = event.getServletContext().getInitParameter("WELD_CONTEXT_ID_KEY");
        }
        if (this.contextId == null) {
            this.contextId = "STATIC_INSTANCE";
        }
        log.trace(ServletMessage.REQUEST_DESTROYED, event.getServletRequest());
        if (!Container.available(this.contextId)) return;
        if (!(event.getServletRequest() instanceof HttpServletRequest)) throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        try {
            this.requestContext(this.contextId).invalidate();
            this.requestContext(this.contextId).deactivate();
            this.sessionContext(this.contextId).deactivate();
            if (!this.conversationContext(this.contextId).isActive()) return;
            this.conversationContext(this.contextId).deactivate();
            return;
        }
        finally {
            this.requestContext(this.contextId).dissociate(request);
            this.sessionContext(this.contextId).dissociate(request);
            this.conversationContext(this.contextId).dissociate(request);
        }
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        if (this.contextId == null) {
            this.contextId = event.getServletContext().getInitParameter("WELD_CONTEXT_ID_KEY");
        }
        if (this.contextId == null) {
            this.contextId = "STATIC_INSTANCE";
        }
        log.trace(ServletMessage.REQUEST_INITIALIZED, event.getServletRequest());
        if (Container.available(this.contextId)) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
                this.requestContext(this.contextId).associate(request);
                this.sessionContext(this.contextId).associate(request);
                this.conversationContext(this.contextId).associate(request);
                this.requestContext(this.contextId).activate();
                this.sessionContext(this.contextId).activate();
            } else {
                throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
            }
        }
    }
}

