/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.cache;

import java.util.LinkedList;
import java.util.List;
import org.jboss.weld.context.cache.RequestScopedItem;

public class RequestScopedBeanCache {
    private static final ThreadLocal<List<RequestScopedItem>> CACHE = new ThreadLocal();

    public static boolean isActive() {
        return CACHE.get() != null;
    }

    public static void addItem(RequestScopedItem item) {
        List<RequestScopedItem> cache = CACHE.get();
        if (cache == null) {
            throw new IllegalStateException("Unable to add request scoped cache item when request cache is not active");
        }
        cache.add(item);
    }

    public static void addItem(final ThreadLocal item) {
        List<RequestScopedItem> cache = CACHE.get();
        if (cache == null) {
            throw new IllegalStateException("Unable to add request scoped cache item when request cache is not active");
        }
        cache.add(new RequestScopedItem(){

            @Override
            public void invalidate() {
                item.remove();
            }
        });
    }

    public static void beginRequest() {
        CACHE.set(new LinkedList());
    }

    public static void endRequest() {
        List<RequestScopedItem> result = CACHE.get();
        CACHE.remove();
        if (result != null) {
            for (RequestScopedItem item : result) {
                item.invalidate();
            }
        }
    }

    public static void invalidate() {
        if (RequestScopedBeanCache.isActive()) {
            RequestScopedBeanCache.endRequest();
            RequestScopedBeanCache.beginRequest();
        }
    }
}

