/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import org.jboss.classfilewriter.code.CodeAttribute;

public class BytecodeUtils {
    private static final String TYPE = "TYPE";
    private static final String LJAVA_LANG_CLASS = "Ljava/lang/Class;";

    private BytecodeUtils() {
    }

    public static void addLoadInstruction(CodeAttribute code, String type, int variable) {
        char tp = type.charAt(0);
        if (tp != 'L' && tp != '[') {
            switch (tp) {
                case 'J': {
                    code.lload(variable);
                    break;
                }
                case 'D': {
                    code.dload(variable);
                    break;
                }
                case 'F': {
                    code.fload(variable);
                    break;
                }
                default: {
                    code.iload(variable);
                    break;
                }
            }
        } else {
            code.aload(variable);
        }
    }

    public static void pushClassType(CodeAttribute b, String classType) {
        if (classType.length() != 1) {
            if (classType.startsWith("L") && classType.endsWith(";")) {
                classType = classType.substring(1, classType.length() - 1);
            }
            b.loadClass(classType);
        } else {
            char type = classType.charAt(0);
            switch (type) {
                case 'I': {
                    b.getstatic(Integer.class.getName(), TYPE, LJAVA_LANG_CLASS);
                    break;
                }
                case 'J': {
                    b.getstatic(Long.class.getName(), TYPE, LJAVA_LANG_CLASS);
                    break;
                }
                case 'S': {
                    b.getstatic(Short.class.getName(), TYPE, LJAVA_LANG_CLASS);
                    break;
                }
                case 'F': {
                    b.getstatic(Float.class.getName(), TYPE, LJAVA_LANG_CLASS);
                    break;
                }
                case 'D': {
                    b.getstatic(Double.class.getName(), TYPE, LJAVA_LANG_CLASS);
                    break;
                }
                case 'B': {
                    b.getstatic(Byte.class.getName(), TYPE, LJAVA_LANG_CLASS);
                    break;
                }
                case 'C': {
                    b.getstatic(Character.class.getName(), TYPE, LJAVA_LANG_CLASS);
                    break;
                }
                case 'Z': {
                    b.getstatic(Boolean.class.getName(), TYPE, LJAVA_LANG_CLASS);
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot handle primitive type: " + type);
                }
            }
        }
    }
}

