/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.util.reflection.Reflections;

public class SlimAnnotatedTypeStoreImpl
implements SlimAnnotatedTypeStore,
Service {
    private final LoadingCache<Class<?>, Set<SlimAnnotatedType<?>>> typesByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Set<SlimAnnotatedType<?>>>(){

        public Set<SlimAnnotatedType<?>> load(Class<?> input) {
            return new CopyOnWriteArraySet();
        }
    });

    @Override
    public <X> SlimAnnotatedType<X> get(Class<X> type, String suffix) {
        for (SlimAnnotatedType annotatedType : this.get((Class)type)) {
            if (!Objects.equal((Object)((AnnotatedTypeIdentifier)annotatedType.getIdentifier()).getSuffix(), (Object)suffix)) continue;
            return annotatedType;
        }
        return null;
    }

    public <X> Set<SlimAnnotatedType<X>> get(Class<X> type) {
        return (Set)Reflections.cast(Collections.unmodifiableSet((Set)this.typesByClass.getUnchecked(type)));
    }

    @Override
    public <X> void put(SlimAnnotatedType<X> type) {
        ((Set)this.typesByClass.getUnchecked((Object)type.getJavaClass())).add(type);
    }

    @Override
    public void cleanup() {
        this.typesByClass.invalidateAll();
    }
}

