/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.attributes;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.logging.MetadataLogger;

public class ExternalBeanAttributesFactory {
    private ExternalBeanAttributesFactory() {
    }

    public static <T> BeanAttributes<T> of(BeanAttributes<T> source, BeanManager manager) {
        ExternalBeanAttributesFactory.validateBeanAttributes(source, manager);
        ImmutableBeanAttributes attributes = new ImmutableBeanAttributes(ExternalBeanAttributesFactory.defensiveCopy(source.getStereotypes()), source.isAlternative(), source.getName(), ExternalBeanAttributesFactory.defensiveCopy(source.getQualifiers()), ExternalBeanAttributesFactory.defensiveCopy(source.getTypes()), source.getScope());
        return attributes;
    }

    private static <T> Set<T> defensiveCopy(Set<T> set) {
        return new HashSet<T>(set);
    }

    public static void validateBeanAttributes(BeanAttributes<?> attributes, BeanManager manager) {
        ExternalBeanAttributesFactory.validateStereotypes(attributes, manager);
        ExternalBeanAttributesFactory.validateQualifiers(attributes, manager);
        ExternalBeanAttributesFactory.validateTypes(attributes, manager);
        ExternalBeanAttributesFactory.validateScope(attributes, manager);
    }

    public static void validateStereotypes(BeanAttributes<?> attributes, BeanManager manager) {
        if (attributes.getStereotypes() == null) {
            throw MetadataLogger.LOG.stereotypesNull(attributes);
        }
        for (Class annotation : attributes.getStereotypes()) {
            if (manager.isStereotype(annotation)) continue;
            throw MetadataLogger.LOG.notAStereotype(annotation, attributes);
        }
    }

    public static void validateQualifiers(BeanAttributes<?> attributes, BeanManager manager) {
        if (attributes.getQualifiers() == null) {
            throw MetadataLogger.LOG.qualifiersNull(attributes);
        }
        for (Annotation annotation : attributes.getQualifiers()) {
            if (manager.isQualifier(annotation.annotationType())) continue;
            throw MetadataLogger.LOG.notAQualifier(annotation.annotationType(), attributes);
        }
    }

    public static void validateTypes(BeanAttributes<?> attributes, BeanManager manager) {
        if (attributes.getTypes() == null) {
            throw MetadataLogger.LOG.typesNull(attributes);
        }
        if (attributes.getTypes().isEmpty()) {
            throw MetadataLogger.LOG.typesEmpty(attributes);
        }
        for (Type type : attributes.getTypes()) {
            ExternalBeanAttributesFactory.validateBeanType(type, attributes);
        }
    }

    private static void validateBeanType(Type type, BeanAttributes<?> attributes) {
        ExternalBeanAttributesFactory.checkBeanTypeNotATypeVariable(type, type, attributes);
        ExternalBeanAttributesFactory.checkBeanTypeForWildcardsAndTypeVariables(type, type, attributes);
    }

    private static void checkBeanTypeNotATypeVariable(Type beanType, Type type, BeanAttributes<?> attributes) {
        if (type instanceof TypeVariable) {
            throw MetadataLogger.LOG.typeVariableIsNotAValidBeanType(beanType, attributes);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            ExternalBeanAttributesFactory.checkBeanTypeNotATypeVariable(beanType, arrayType.getGenericComponentType(), attributes);
        }
    }

    private static void checkBeanTypeForWildcardsAndTypeVariables(Type beanType, Type type, BeanAttributes<?> attributes) {
        if (type instanceof TypeVariable) {
            if (!attributes.getScope().equals(Dependent.class)) {
                throw MetadataLogger.LOG.beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped(beanType, attributes);
            }
        } else {
            if (type instanceof WildcardType) {
                throw MetadataLogger.LOG.parameterizedTypeContainingWildcardParameterIsNotAValidBeanType(beanType, attributes);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                    ExternalBeanAttributesFactory.checkBeanTypeForWildcardsAndTypeVariables(beanType, typeArgument, attributes);
                }
            } else if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                ExternalBeanAttributesFactory.checkBeanTypeForWildcardsAndTypeVariables(beanType, arrayType.getGenericComponentType(), attributes);
            }
        }
    }

    public static void validateScope(BeanAttributes<?> attributes, BeanManager manager) {
        if (attributes.getScope() == null) {
            throw MetadataLogger.LOG.scopeNull(attributes);
        }
        if (!manager.isScope(attributes.getScope())) {
            throw MetadataLogger.LOG.notAScope(attributes.getScope(), attributes);
        }
    }
}

