/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.ObjectStreamException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.code.ExceptionHandler;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.util.SerializableClientProxy;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.security.GetDeclaredFieldAction;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.bytecode.DeferredBytecode;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodInformation;

public class ClientProxyFactory<T>
extends ProxyFactory<T> {
    private static final Set<Class<? extends Annotation>> CACHEABLE_SCOPES;
    public static final String CLIENT_PROXY_SUFFIX = "ClientProxy";
    private static final String CACHE_FIELD = "BEAN_INSTANCE_CACHE";
    private static final String INTERCEPTION_DECORATION_CONTEXT_CLASS_NAME;
    private static final String HASH_CODE_METHOD = "hashCode";
    private static final String EMPTY_PARENTHESES = "()";
    private static final String END_INTERCEPTOR_CONTEXT_METHOD_NAME = "endInterceptorContext";
    private static final String START_INTERCEPTOR_CONTEXT_METHOD_NAME = "startInterceptorContext";
    private static final String BEAN_ID_FIELD = "BEAN_ID_FIELD";
    private final BeanIdentifier beanId;
    private volatile Field beanIdField;
    private volatile Field threadLocalCacheField;

    public ClientProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        super(contextId, proxiedBeanType, typeClosure, bean);
        this.beanId = Container.instance(contextId).services().get(ContextualStore.class).putIfAbsent((Contextual<?>)bean);
    }

    @Override
    public T create(BeanInstance beanInstance) {
        try {
            Field f;
            Object instance = super.create(beanInstance);
            if (this.beanIdField == null) {
                f = AccessController.doPrivileged(new GetDeclaredFieldAction(instance.getClass(), BEAN_ID_FIELD));
                AccessController.doPrivileged(SetAccessibleAction.of(f));
                this.beanIdField = f;
            }
            if (this.threadLocalCacheField == null && this.isUsingUnsafeInstantiators()) {
                f = AccessController.doPrivileged(new GetDeclaredFieldAction(instance.getClass(), CACHE_FIELD));
                AccessController.doPrivileged(SetAccessibleAction.of(f));
                this.threadLocalCacheField = f;
            }
            if (this.isUsingUnsafeInstantiators()) {
                this.threadLocalCacheField.set(instance, new ThreadLocal());
            }
            this.beanIdField.set(instance, this.beanId);
            return instance;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    protected void addFields(final ClassFile proxyClassType, List<DeferredBytecode> initialValueBytecode) {
        super.addFields(proxyClassType, initialValueBytecode);
        if (CACHEABLE_SCOPES.contains(this.getBean().getScope())) {
            try {
                proxyClassType.addField(130, CACHE_FIELD, "Ljava/lang/ThreadLocal;");
                initialValueBytecode.add(new DeferredBytecode(){

                    @Override
                    public void apply(CodeAttribute codeAttribute) {
                        codeAttribute.aload(0);
                        codeAttribute.newInstruction(ThreadLocal.class.getName());
                        codeAttribute.dup();
                        codeAttribute.invokespecial(ThreadLocal.class.getName(), "<init>", "()V");
                        codeAttribute.putfield(proxyClassType.getName(), ClientProxyFactory.CACHE_FIELD, "Ljava/lang/ThreadLocal;");
                    }
                });
            }
            catch (DuplicateMemberException e) {
                throw new RuntimeException(e);
            }
        }
        proxyClassType.addField(66, BEAN_ID_FIELD, BeanIdentifier.class);
    }

    @Override
    protected void addSerializationSupport(ClassFile proxyClassType) {
        Class[] exceptions = new Class[]{ObjectStreamException.class};
        ClassMethod writeReplace = proxyClassType.addMethod(2, "writeReplace", "Ljava/lang/Object;", new String[0]);
        writeReplace.addCheckedExceptions(exceptions);
        CodeAttribute b = writeReplace.getCodeAttribute();
        b.newInstruction(SerializableClientProxy.class.getName());
        b.dup();
        b.aload(0);
        b.getfield(proxyClassType.getName(), BEAN_ID_FIELD, BeanIdentifier.class);
        b.ldc(this.getContextId());
        b.invokespecial(SerializableClientProxy.class.getName(), "<init>", "(Lorg/jboss/weld/serialization/spi/BeanIdentifier;Ljava/lang/String;)V");
        b.returnInstruction();
    }

    @Override
    protected void createForwardingMethodBody(ClassMethod classMethod, MethodInformation methodInfo) {
        Method method = methodInfo.getMethod();
        boolean bytecodeInvocationAllowed = Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getReturnType().getModifiers());
        for (Class<?> paramType : method.getParameterTypes()) {
            if (Modifier.isPublic(paramType.getModifiers())) continue;
            bytecodeInvocationAllowed = false;
            break;
        }
        if (!bytecodeInvocationAllowed) {
            this.createInterceptorBody(classMethod, methodInfo);
            return;
        }
        CodeAttribute b = classMethod.getCodeAttribute();
        ExceptionHandler start = b.exceptionBlockStart(Throwable.class.getName());
        b.invokestatic(INTERCEPTION_DECORATION_CONTEXT_CLASS_NAME, START_INTERCEPTOR_CONTEXT_METHOD_NAME, "()V");
        Class scope = this.getBean().getScope();
        if (CACHEABLE_SCOPES.contains(scope)) {
            this.loadCacheableBeanInstance(classMethod.getClassFile(), methodInfo, b);
        } else {
            this.loadBeanInstance(classMethod.getClassFile(), methodInfo, b);
        }
        b.dup();
        String methodDescriptor = methodInfo.getDescriptor();
        b.loadMethodParameters();
        if (method.getDeclaringClass().isInterface()) {
            b.invokeinterface(methodInfo.getDeclaringClass(), methodInfo.getName(), methodDescriptor);
        } else {
            b.invokevirtual(methodInfo.getDeclaringClass(), methodInfo.getName(), methodDescriptor);
        }
        b.invokestatic(INTERCEPTION_DECORATION_CONTEXT_CLASS_NAME, END_INTERCEPTOR_CONTEXT_METHOD_NAME, "()V");
        BranchEnd gotoEnd = b.gotoInstruction();
        b.exceptionBlockEnd(start);
        b.exceptionHandlerStart(start);
        b.invokestatic(INTERCEPTION_DECORATION_CONTEXT_CLASS_NAME, END_INTERCEPTOR_CONTEXT_METHOD_NAME, "()V");
        b.athrow();
        b.branchEnd(gotoEnd);
        if (method.getReturnType().isPrimitive()) {
            b.returnInstruction();
        } else {
            b.dupX1();
            BranchEnd returnInstruction = b.ifAcmpeq();
            b.returnInstruction();
            b.branchEnd(returnInstruction);
            b.aload(0);
            b.checkcast(methodInfo.getMethod().getReturnType().getName());
            b.returnInstruction();
        }
    }

    private void loadCacheableBeanInstance(ClassFile file, MethodInformation methodInfo, CodeAttribute b) {
        b.invokestatic(RequestScopedBeanCache.class.getName(), "isActive", "()Z");
        BranchEnd returnInstruction = b.ifeq();
        b.aload(0);
        b.getfield(file.getName(), CACHE_FIELD, "Ljava/lang/ThreadLocal;");
        b.invokevirtual(ThreadLocal.class.getName(), "get", "()Ljava/lang/Object;");
        b.dup();
        BranchEnd createNewInstance = b.ifnull();
        b.checkcast(methodInfo.getDeclaringClass());
        BranchEnd loadedFromCache = b.gotoInstruction();
        b.branchEnd(createNewInstance);
        b.pop();
        this.loadBeanInstance(file, methodInfo, b);
        b.dup();
        b.aload(0);
        b.getfield(file.getName(), CACHE_FIELD, "Ljava/lang/ThreadLocal;");
        b.dupX1();
        b.swap();
        b.invokevirtual(ThreadLocal.class.getName(), "set", "(Ljava/lang/Object;)V");
        b.invokestatic(RequestScopedBeanCache.class.getName(), "addItem", "(Ljava/lang/ThreadLocal;)V");
        BranchEnd endOfIfStatement = b.gotoInstruction();
        b.branchEnd(returnInstruction);
        this.loadBeanInstance(file, methodInfo, b);
        b.branchEnd(endOfIfStatement);
        b.branchEnd(loadedFromCache);
    }

    private void loadBeanInstance(ClassFile file, MethodInformation methodInfo, CodeAttribute b) {
        b.aload(0);
        b.getfield(file.getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.aload(0);
        b.aconstNull();
        b.aconstNull();
        b.aconstNull();
        b.invokeinterface(MethodHandler.class.getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;");
        b.checkcast(methodInfo.getDeclaringClass());
    }

    @Override
    protected void generateHashCodeMethod(ClassFile proxyClassType) {
        ClassMethod method = proxyClassType.addMethod(1, HASH_CODE_METHOD, "I", new String[0]);
        CodeAttribute b = method.getCodeAttribute();
        b.loadClass(proxyClassType.getName());
        b.invokevirtual("java.lang.Object", HASH_CODE_METHOD, "()I");
        b.returnInstruction();
    }

    @Override
    protected void generateEqualsMethod(ClassFile proxyClassType) {
        ClassMethod method = proxyClassType.addMethod(1, "equals", "Z", "Ljava/lang/Object;");
        CodeAttribute b = method.getCodeAttribute();
        b.aload(1);
        b.instanceofInstruction(proxyClassType.getName());
        b.returnInstruction();
    }

    @Override
    protected String getProxyNameSuffix() {
        return CLIENT_PROXY_SUFFIX;
    }

    static {
        INTERCEPTION_DECORATION_CONTEXT_CLASS_NAME = InterceptionDecorationContext.class.getName();
        HashSet<Class> scopes = new HashSet<Class>();
        scopes.add(RequestScoped.class);
        scopes.add(ConversationScoped.class);
        scopes.add(SessionScoped.class);
        scopes.add(ApplicationScoped.class);
        CACHEABLE_SCOPES = Collections.unmodifiableSet(scopes);
    }
}

