/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.TypeClosureLazyValueHolder;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.collections.WeldCollections;

public class SharedObjectCache
implements BootstrapService {
    private final LoadingCache<Set<?>, Set<?>> sharedSets = CacheBuilder.newBuilder().build(new CacheLoader<Set<?>, Set<?>>(){

        public Set<?> load(Set<?> from) {
            return WeldCollections.immutableSet(from);
        }
    });
    private final LoadingCache<Map<?, ?>, Map<?, ?>> sharedMaps = CacheBuilder.newBuilder().build(new CacheLoader<Map<?, ?>, Map<?, ?>>(){

        public Map<?, ?> load(Map<?, ?> from) {
            return WeldCollections.immutableMap(from);
        }
    });
    private final LoadingCache<ArraySetMultimap<?, ?>, ArraySetMultimap<?, ?>> sharedMultiMaps = CacheBuilder.newBuilder().build(new CacheLoader<ArraySetMultimap<?, ?>, ArraySetMultimap<?, ?>>(){

        public ArraySetMultimap<?, ?> load(ArraySetMultimap<?, ?> from) {
            return from;
        }
    });
    private final LoadingCache<Type, LazyValueHolder<Set<Type>>> typeClosureHolders = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Type, LazyValueHolder<Set<Type>>>(){

        public LazyValueHolder<Set<Type>> load(Type input) {
            return new TypeClosureLazyValueHolder(input);
        }
    });
    private final LoadingCache<Type, Type> resolvedTypes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Type, Type>(){

        public Type load(Type from) {
            return Types.getCanonicalType(from);
        }
    });

    public static SharedObjectCache instance(BeanManagerImpl manager) {
        return manager.getServices().get(SharedObjectCache.class);
    }

    public <T> Set<T> getSharedSet(Set<T> set) {
        return (Set)LoadingCacheUtils.getCastCacheValue(this.sharedSets, set);
    }

    public <K, V> Map<K, V> getSharedMap(Map<K, V> map) {
        return (Map)LoadingCacheUtils.getCastCacheValue(this.sharedMaps, map);
    }

    public <K, V> ArraySetMultimap<K, V> getSharedMultimap(ArraySetMultimap<K, V> map) {
        return (ArraySetMultimap)LoadingCacheUtils.getCastCacheValue(this.sharedMultiMaps, map);
    }

    public LazyValueHolder<Set<Type>> getTypeClosureHolder(Type type) {
        return LoadingCacheUtils.getCacheValue(this.typeClosureHolders, type);
    }

    public Type getResolvedType(Type type) {
        return (Type)this.resolvedTypes.getUnchecked((Object)type);
    }

    @Override
    public void cleanupAfterBoot() {
        this.sharedSets.invalidateAll();
        this.sharedMaps.invalidateAll();
        this.sharedMultiMaps.invalidateAll();
        this.typeClosureHolders.invalidateAll();
    }

    @Override
    public void cleanup() {
        this.cleanupAfterBoot();
        this.resolvedTypes.invalidateAll();
    }
}

