/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.jboss.weld.util.reflection.Reflections;

public final class DeclaredMemberIndexer {
    private static final ConstructorComparator CONSTRUCTOR_COMPARATOR_INSTANCE = new ConstructorComparator();
    private static final MethodComparator METHOD_COMPARATOR_INSTANCE = new MethodComparator();
    private static final FieldComparator FIELD_COMPARATOR_INSTANCE = new FieldComparator();

    private DeclaredMemberIndexer() {
    }

    public static int getIndexForField(Field field) {
        Preconditions.checkNotNull((Object)field);
        return DeclaredMemberIndexer.getIndexForMember(field, DeclaredMemberIndexer.getDeclaredFields(field.getDeclaringClass()));
    }

    public static Field getFieldForIndex(int index, Class<?> declaringClass) {
        return DeclaredMemberIndexer.getDeclaredFields(declaringClass).get(index);
    }

    public static int getIndexForMethod(Method method) {
        Preconditions.checkNotNull((Object)method);
        return DeclaredMemberIndexer.getIndexForMember(method, DeclaredMemberIndexer.getDeclaredMethods(method.getDeclaringClass()));
    }

    public static Method getMethodForIndex(int index, Class<?> declaringClass) {
        return DeclaredMemberIndexer.getDeclaredMethods(declaringClass).get(index);
    }

    public static int getIndexForConstructor(Constructor<?> constructor) {
        Preconditions.checkNotNull(constructor);
        return DeclaredMemberIndexer.getIndexForMember(constructor, DeclaredMemberIndexer.getDeclaredConstructors(constructor.getDeclaringClass()));
    }

    public static <T> Constructor<T> getConstructorForIndex(int index, Class<T> declaringClass) {
        return (Constructor)Reflections.cast(DeclaredMemberIndexer.getDeclaredConstructors(declaringClass).get(index));
    }

    private static <T extends Member> int getIndexForMember(T declaredMember, List<T> declaredMembers) {
        ListIterator<T> iterator = declaredMembers.listIterator();
        while (iterator.hasNext()) {
            Member member = (Member)iterator.next();
            if (!member.equals(declaredMember)) continue;
            return iterator.previousIndex();
        }
        throw new IllegalStateException("No matching declared member found for: " + declaredMember);
    }

    public static List<Field> getDeclaredFields(Class<?> declaringClass) {
        Preconditions.checkNotNull(declaringClass);
        List<Field> declaredFields = Arrays.asList(declaringClass.getDeclaredFields());
        Collections.sort(declaredFields, FIELD_COMPARATOR_INSTANCE);
        return declaredFields;
    }

    public static List<Method> getDeclaredMethods(Class<?> declaringClass) {
        Preconditions.checkNotNull(declaringClass);
        List<Method> declaredMethods = Arrays.asList(declaringClass.getDeclaredMethods());
        Collections.sort(declaredMethods, METHOD_COMPARATOR_INSTANCE);
        return declaredMethods;
    }

    public static List<Constructor<?>> getDeclaredConstructors(Class<?> declaringClass) {
        Preconditions.checkNotNull(declaringClass);
        List<Constructor<?>> declaredConstructors = Arrays.asList(declaringClass.getDeclaredConstructors());
        Collections.sort(declaredConstructors, CONSTRUCTOR_COMPARATOR_INSTANCE);
        return declaredConstructors;
    }

    private static int compareParamTypes(Class<?>[] paramTypes1, Class<?>[] paramTypes2) {
        if (paramTypes1.length != paramTypes2.length) {
            return paramTypes1.length - paramTypes2.length;
        }
        for (int i = 0; i < paramTypes1.length; ++i) {
            if (paramTypes1[i].getName().equals(paramTypes2[i].getName())) continue;
            return paramTypes1[i].getName().compareTo(paramTypes2[i].getName());
        }
        return 0;
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method m1, Method m2) {
            if (!m1.getName().equals(m2.getName())) {
                return m1.getName().compareTo(m2.getName());
            }
            return DeclaredMemberIndexer.compareParamTypes(m1.getParameterTypes(), m2.getParameterTypes());
        }
    }

    private static class ConstructorComparator
    implements Comparator<Constructor<?>> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(Constructor<?> c1, Constructor<?> c2) {
            return DeclaredMemberIndexer.compareParamTypes(c1.getParameterTypes(), c2.getParameterTypes());
        }
    }
}

