/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.inject.Scope;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedParameter;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.Arrays2;

public class DefaultReflectionCache
extends AbstractBootstrapService
implements ReflectionCache {
    private final TypeStore store;
    private final LoadingCache<AnnotatedElement, Annotations> annotations;
    private final LoadingCache<AnnotatedElement, Annotations> declaredAnnotations;
    private final LoadingCache<Constructor<?>, Annotation[][]> constructorParameterAnnotations;
    private final LoadingCache<Method, Annotation[][]> methodParameterAnnotations;
    private final LoadingCache<BackedAnnotatedParameter<?>, Set<Annotation>> parameterAnnotationSet;
    private final LoadingCache<Class<?>, Set<Annotation>> backedAnnotatedTypeAnnotations;
    private final LoadingCache<Class<? extends Annotation>, Boolean> isScopeAnnotation;

    protected Annotation[] internalGetAnnotations(AnnotatedElement element) {
        return element.getAnnotations();
    }

    protected Annotation[] internalGetDeclaredAnnotations(AnnotatedElement element) {
        return element.getDeclaredAnnotations();
    }

    public DefaultReflectionCache(TypeStore store) {
        this.store = store;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        this.annotations = cacheBuilder.build((CacheLoader)new CacheLoader<AnnotatedElement, Annotations>(){

            public Annotations load(AnnotatedElement input) {
                return new Annotations(DefaultReflectionCache.this.internalGetAnnotations(input));
            }
        });
        this.declaredAnnotations = cacheBuilder.build((CacheLoader)new CacheLoader<AnnotatedElement, Annotations>(){

            public Annotations load(AnnotatedElement input) {
                return new Annotations(DefaultReflectionCache.this.internalGetDeclaredAnnotations(input));
            }
        });
        this.constructorParameterAnnotations = cacheBuilder.build(new CacheLoader<Constructor<?>, Annotation[][]>(){

            public Annotation[][] load(Constructor<?> input) {
                return input.getParameterAnnotations();
            }
        });
        this.methodParameterAnnotations = cacheBuilder.build((CacheLoader)new CacheLoader<Method, Annotation[][]>(){

            public Annotation[][] load(Method input) {
                return input.getParameterAnnotations();
            }
        });
        this.parameterAnnotationSet = cacheBuilder.build(new CacheLoader<BackedAnnotatedParameter<?>, Set<Annotation>>(){

            public Set<Annotation> load(BackedAnnotatedParameter<?> parameter) throws Exception {
                Member member = parameter.getDeclaringCallable().getJavaMember();
                if (member instanceof Method) {
                    return ImmutableSet.copyOf((Object[])DefaultReflectionCache.this.getParameterAnnotations((Method)member, parameter.getPosition()));
                }
                return ImmutableSet.copyOf((Object[])DefaultReflectionCache.this.getParameterAnnotations((Constructor)member, parameter.getPosition()));
            }
        });
        this.backedAnnotatedTypeAnnotations = cacheBuilder.build((CacheLoader)new BackedAnnotatedTypeAnnotationsFunction());
        this.isScopeAnnotation = cacheBuilder.build((CacheLoader)new IsScopeAnnotationFunction());
    }

    @Override
    public Annotation[] getAnnotations(AnnotatedElement element) {
        return LoadingCacheUtils.getCacheValue(this.annotations, element).annotations;
    }

    @Override
    public Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        return LoadingCacheUtils.getCacheValue(this.declaredAnnotations, element).annotations;
    }

    @Override
    public Annotation[] getParameterAnnotations(Constructor<?> constructor, int parameterPosition) {
        return LoadingCacheUtils.getCacheValue(this.constructorParameterAnnotations, constructor)[parameterPosition];
    }

    @Override
    public Annotation[] getParameterAnnotations(Method method, int parameterPosition) {
        return LoadingCacheUtils.getCacheValue(this.methodParameterAnnotations, method)[parameterPosition];
    }

    @Override
    public void cleanupAfterBoot() {
        this.annotations.invalidateAll();
        this.declaredAnnotations.invalidateAll();
        this.constructorParameterAnnotations.invalidateAll();
        this.methodParameterAnnotations.invalidateAll();
        this.backedAnnotatedTypeAnnotations.invalidateAll();
        this.isScopeAnnotation.invalidateAll();
        this.parameterAnnotationSet.invalidateAll();
    }

    @Override
    public Set<Annotation> getAnnotationSet(AnnotatedElement element) {
        return LoadingCacheUtils.getCacheValue(this.annotations, element).annotationSet;
    }

    @Override
    public Set<Annotation> getDeclaredAnnotationSet(AnnotatedElement element) {
        return LoadingCacheUtils.getCacheValue(this.declaredAnnotations, element).annotationSet;
    }

    @Override
    public Set<Annotation> getParameterAnnotationSet(BackedAnnotatedParameter<?> parameter) {
        return LoadingCacheUtils.getCacheValue(this.parameterAnnotationSet, parameter);
    }

    @Override
    public Set<Annotation> getBackedAnnotatedTypeAnnotationSet(Class<?> javaClass) {
        return LoadingCacheUtils.getCacheValue(this.backedAnnotatedTypeAnnotations, javaClass);
    }

    private class IsScopeAnnotationFunction
    extends CacheLoader<Class<? extends Annotation>, Boolean> {
        private IsScopeAnnotationFunction() {
        }

        public Boolean load(Class<? extends Annotation> input) {
            if (input.isAnnotationPresent(NormalScope.class)) {
                return true;
            }
            if (input.isAnnotationPresent(Scope.class)) {
                return true;
            }
            return DefaultReflectionCache.this.store.isExtraScope(input);
        }
    }

    private class BackedAnnotatedTypeAnnotationsFunction
    extends CacheLoader<Class<?>, Set<Annotation>> {
        private BackedAnnotatedTypeAnnotationsFunction() {
        }

        public Set<Annotation> load(Class<?> javaClass) {
            Set<Annotation> annotations = DefaultReflectionCache.this.getAnnotationSet(javaClass);
            boolean scopeFound = false;
            for (Annotation annotation : annotations) {
                boolean isScope = (Boolean)LoadingCacheUtils.getCacheValue(DefaultReflectionCache.this.isScopeAnnotation, annotation.annotationType());
                if (isScope && scopeFound) {
                    return this.applyScopeInheritanceRules(annotations, javaClass);
                }
                if (!isScope) continue;
                scopeFound = true;
            }
            return annotations;
        }

        public Set<Annotation> applyScopeInheritanceRules(Set<Annotation> annotations, Class<?> javaClass) {
            HashSet<Annotation> result = new HashSet<Annotation>();
            for (Annotation annotation : annotations) {
                if (((Boolean)LoadingCacheUtils.getCacheValue(DefaultReflectionCache.this.isScopeAnnotation, annotation.annotationType())).booleanValue()) continue;
                result.add(annotation);
            }
            result.addAll(this.findTopLevelScopeDefinitions(javaClass));
            return ImmutableSet.copyOf(result);
        }

        public Set<Annotation> findTopLevelScopeDefinitions(Class<?> javaClass) {
            for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                HashSet<Annotation> scopes = new HashSet<Annotation>();
                for (Annotation annotation : DefaultReflectionCache.this.getDeclaredAnnotations(clazz)) {
                    if (!((Boolean)LoadingCacheUtils.getCacheValue(DefaultReflectionCache.this.isScopeAnnotation, annotation.annotationType())).booleanValue()) continue;
                    scopes.add(annotation);
                }
                if (scopes.size() <= 0) continue;
                return scopes;
            }
            throw new IllegalStateException();
        }
    }

    private static class Annotations {
        private final Annotation[] annotations;
        private final Set<Annotation> annotationSet;

        public Annotations(Annotation[] annotations) {
            if (annotations.length == 0) {
                this.annotations = Arrays2.EMPTY_ANNOTATION_ARRAY;
                this.annotationSet = Collections.emptySet();
            } else {
                this.annotations = annotations;
                this.annotationSet = ImmutableSet.copyOf((Object[])annotations);
            }
        }
    }
}

