/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.bootstrap.AnnotatedTypeLoader;
import org.jboss.weld.bootstrap.FastProcessAnnotatedTypeResolver;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.event.ExtensionObserverMethodImpl;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassLoaderResourceLoader;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.resources.spi.ClassFileInfoException;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.security.GetDeclaredMethodAction;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

class FastAnnotatedTypeLoader
extends AnnotatedTypeLoader {
    private final ClassFileServices classFileServices;
    private final FastProcessAnnotatedTypeResolver resolver;
    private final AnnotatedTypeLoader fallback;
    private final boolean checkTypeModifiers;
    private static final String CLASSINFO_CLASS_NAME = "org.jboss.jandex.ClassInfo";

    FastAnnotatedTypeLoader(BeanManagerImpl manager, ClassTransformer transformer, ClassFileServices classFileServices, ContainerLifecycleEvents events, FastProcessAnnotatedTypeResolver resolver) {
        super(manager, transformer, events);
        this.fallback = new AnnotatedTypeLoader(manager, transformer, events);
        this.classFileServices = classFileServices;
        this.resolver = resolver;
        this.checkTypeModifiers = this.initCheckTypeModifiers();
    }

    @Override
    public <T> SlimAnnotatedTypeContext<T> loadAnnotatedType(String className, String bdaId) {
        try {
            ClassFileInfo classFileInfo = this.classFileServices.getClassFileInfo(className);
            if ((classFileInfo.getModifiers() & 0x2000) != 0) {
                return null;
            }
            if (classFileInfo.isVetoed()) {
                return null;
            }
            Set<Object> observerMethods = Collections.emptySet();
            if (this.containerLifecycleEvents.isProcessAnnotatedTypeObserved() && !(observerMethods = this.resolver.resolveProcessAnnotatedTypeObservers(this.classFileServices, className)).isEmpty()) {
                return this.createContext(className, classFileInfo, observerMethods, bdaId);
            }
            if (Beans.isDecoratorDeclaringInAppropriateConstructor(classFileInfo)) {
                BootstrapLogger.LOG.decoratorWithNonCdiConstructor(classFileInfo.getClassName());
            }
            if (Beans.isTypeManagedBeanOrDecoratorOrInterceptor(classFileInfo, this.checkTypeModifiers)) {
                return this.createContext(className, classFileInfo, observerMethods, bdaId);
            }
            return null;
        }
        catch (ClassFileInfoException e) {
            BootstrapLogger.LOG.exceptionLoadingAnnotatedType(e.getMessage());
            return this.fallback.loadAnnotatedType(className, bdaId);
        }
    }

    private <T> SlimAnnotatedTypeContext<T> createContext(String className, ClassFileInfo classFileInfo, Set<ExtensionObserverMethodImpl<?, ?>> observerMethods, String bdaId) {
        SlimAnnotatedType type = this.loadAnnotatedType(this.loadClass(className), bdaId);
        if (type != null) {
            return SlimAnnotatedTypeContext.of(type, classFileInfo, observerMethods);
        }
        return null;
    }

    @Override
    protected <T> SlimAnnotatedType<T> loadAnnotatedType(Class<T> clazz, String bdaId) {
        if (clazz != null) {
            try {
                return this.classTransformer.getBackedAnnotatedType(clazz, bdaId);
            }
            catch (ResourceLoadingException e) {
                this.missingDependenciesRegistry.handleResourceLoadingException(clazz.getName(), e);
            }
        }
        return null;
    }

    private boolean initCheckTypeModifiers() {
        Class classInfoclass = Reflections.loadClass(CLASSINFO_CLASS_NAME, new ClassLoaderResourceLoader(this.classFileServices.getClass().getClassLoader()));
        if (classInfoclass != null) {
            try {
                Method setFlags = AccessController.doPrivileged(GetDeclaredMethodAction.of(classInfoclass, "setFlags", Short.TYPE));
                return setFlags != null;
            }
            catch (Exception exceptionIgnored) {
                BootstrapLogger.LOG.usingOldJandexVersion();
                return false;
            }
        }
        return true;
    }
}

