package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-02-15T14:41:50+0100")
public class MetadataLogger_$logger extends DelegatingBasicLogger implements MetadataLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MetadataLogger_$logger.class.getName();
    public MetadataLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String metaAnnotationOnWrongType$str() {
        return "WELD-001100: {0} can only be applied to an annotation.  It was applied to {1}";
    }
    @Override
    public final DefinitionException metaAnnotationOnWrongType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(metaAnnotationOnWrongType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void nonBindingMemberType(final Object param1) {
        super.log.logv(FQCN, WARN, null, nonBindingMemberType$str(), param1);
    }
    protected String nonBindingMemberType$str() {
        return "WELD-001101: Member of array type or annotation type must be annotated @NonBinding:  {0}";
    }
    protected String stereotypeNotRegistered$str() {
        return "WELD-001102: Stereotype {0} not registered with container";
    }
    @Override
    public final IllegalStateException stereotypeNotRegistered(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(stereotypeNotRegistered$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String qualifierOnStereotype$str() {
        return "WELD-001103: Cannot declare qualifiers on stereotype {0}";
    }
    @Override
    public final DefinitionException qualifierOnStereotype(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(qualifierOnStereotype$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String valueOnNamedStereotype$str() {
        return "WELD-001104: Cannot specify a value for @Named stereotype {0}";
    }
    @Override
    public final DefinitionException valueOnNamedStereotype(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(valueOnNamedStereotype$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleScopes$str() {
        return "WELD-001105: At most one scope type may be specified for {0}";
    }
    @Override
    public final DefinitionException multipleScopes(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(multipleScopes$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String stereotypesNull$str() {
        return "WELD-001106: BeanAttributes.getStereotypes() returned null for {0}";
    }
    @Override
    public final DefinitionException stereotypesNull(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(stereotypesNull$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String qualifiersNull$str() {
        return "WELD-001107: {0}() returned null for {1}";
    }
    @Override
    public final DefinitionException qualifiersNull(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(qualifiersNull$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String typesNull$str() {
        return "WELD-001108: BeanAttributes.getTypes() returned null for {0}";
    }
    @Override
    public final DefinitionException typesNull(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(typesNull$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scopeNull$str() {
        return "WELD-001109: BeanAttributes.getScope() returned null for {0}";
    }
    @Override
    public final DefinitionException scopeNull(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(scopeNull$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAStereotype$str() {
        return "WELD-001110: {0} defined on {1} is not a stereotype";
    }
    @Override
    public final DefinitionException notAStereotype(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(notAStereotype$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAQualifier$str() {
        return "WELD-001111: {0} defined on {1} is not a qualifier";
    }
    @Override
    public final DefinitionException notAQualifier(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(notAQualifier$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String typesEmpty$str() {
        return "WELD-001112: BeanAttributes.getTypes() may not return an empty set {0}";
    }
    @Override
    public final DefinitionException typesEmpty(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(typesEmpty$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAScope$str() {
        return "WELD-001113: {0} defined on {1} is not a scope annotation";
    }
    @Override
    public final DefinitionException notAScope(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(notAScope$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String metadataSourceReturnedNull$str() {
        return "WELD-001114: {0} returned null for {1}";
    }
    @Override
    public final IllegalArgumentException metadataSourceReturnedNull(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(metadataSourceReturnedNull$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParameterPosition$str() {
        return "WELD-001115: Parameter position {0} of parameter {1} is not valid";
    }
    @Override
    public final IllegalArgumentException invalidParameterPosition(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidParameterPosition$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void noConstructor(final Object param1) {
        super.log.logv(FQCN, WARN, null, noConstructor$str(), param1);
    }
    protected String noConstructor$str() {
        return "WELD-001116: AnnotatedType ({0}) without a constructor";
    }
    @Override
    public final void notInHierarchy(final Object memberName, final Object member, final Object annotatedTypeJavaClassName, final Object annotatedType, final Object stackElement) {
        super.log.logv(FQCN, WARN, null, notInHierarchy$str(), memberName, member, annotatedTypeJavaClassName, annotatedType, stackElement);
    }
    protected String notInHierarchy$str() {
        return "WELD-001117: Member {0} ({1}) does not belong to the actual class hierarchy of the annotatedType {2} ({3})\n\tat {4}";
    }
    protected String typeVariableIsNotAValidBeanType$str() {
        return "WELD-001118: A type variable is not a valid bean type. Bean type {0} of bean {1}";
    }
    @Override
    public final DefinitionException typeVariableIsNotAValidBeanType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(typeVariableIsNotAValidBeanType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parameterizedTypeContainingWildcardParameterIsNotAValidBeanType$str() {
        return "WELD-001119: A parameterized type containing wildcard parameters is not a valid bean type. Bean type {0} of bean {1}";
    }
    @Override
    public final DefinitionException parameterizedTypeContainingWildcardParameterIsNotAValidBeanType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(parameterizedTypeContainingWildcardParameterIsNotAValidBeanType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped$str() {
        return "WELD-001120: A bean that has a parameterized bean type containing type variables must be @Dependent scoped. Bean type {0} of bean {1}";
    }
    @Override
    public final DefinitionException beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonBindingMemberTypeException$str() {
        return "WELD-001121: Member of array type or annotation type must be annotated @NonBinding:  {0}";
    }
    @Override
    public final DefinitionException nonBindingMemberTypeException(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(nonBindingMemberTypeException$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String annotatedTypeDeserializationFailure$str() {
        return "WELD-001122: Failed to deserialize annotated type identified with {0}";
    }
    @Override
    public final IllegalStateException annotatedTypeDeserializationFailure(final AnnotatedTypeIdentifier identifier) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(annotatedTypeDeserializationFailure$str(), identifier));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAnInterceptorBinding$str() {
        return "WELD-001123: {0} defined on {1} is not an interceptor binding";
    }
    @Override
    public final DefinitionException notAnInterceptorBinding(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(_formatMessage(notAnInterceptorBinding$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void contextGetScopeIsNotAScope(final Object param1, final Object param2) {
        super.log.logv(FQCN, WARN, null, contextGetScopeIsNotAScope$str(), param1, param2);
    }
    protected String contextGetScopeIsNotAScope$str() {
        return "WELD-001124: Context.getScope() returned {0} which is not a scope annotation. Context: {1}";
    }
    @Override
    public final void illegalBeanTypeIgnored(final Object type, final Object annotated) {
        super.log.logv(FQCN, INFO, null, illegalBeanTypeIgnored$str(), type, annotated);
    }
    protected String illegalBeanTypeIgnored$str() {
        return "WELD-001125: Illegal bean type {0} ignored on {1}";
    }
    protected String beanAttributesConfiguratorCannotReadAnnotatedType$str() {
        return "WELD-001126: BeanAttributesConfigurator is not able to read {0} - missing BeanManager";
    }
    @Override
    public final IllegalStateException beanAttributesConfiguratorCannotReadAnnotatedType(final Object type) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(beanAttributesConfiguratorCannotReadAnnotatedType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
