/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.jaxrpc.SOAP11BindingJAXRPC;
import org.jboss.ws.core.jaxrpc.SOAP12BindingJAXRPC;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

public class CommonBindingProvider {
    private static final String SOAP11HTTP_BINDING = "http://schemas.xmlsoap.org/wsdl/soap/http";
    private static final String SOAP12HTTP_BINDING = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    protected EndpointMetaData epMetaData;
    protected CommonBinding binding;

    public CommonBindingProvider(EndpointMetaData epMetaData) {
        this.epMetaData = epMetaData;
        this.initBinding(epMetaData.getBindingId());
    }

    public CommonBindingProvider(String bindingId) {
        this.initBinding(bindingId);
    }

    protected void initBinding(String bindingId) {
        if (SOAP11HTTP_BINDING.equals(bindingId)) {
            this.binding = new SOAP11BindingJAXRPC();
        } else if (SOAP12HTTP_BINDING.equals(bindingId)) {
            this.binding = new SOAP12BindingJAXRPC();
        }
    }

    public CommonBinding getCommonBinding() {
        return this.binding;
    }
}

