/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.common.Constants;
import org.jboss.ws.core.CommonSOAPBinding;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.core.soap.utils.SOAPUtils;
import org.jboss.ws.core.soap.utils.Use;
import org.jboss.ws.metadata.umdm.OperationMetaData;

public abstract class CommonSOAP11Binding
extends CommonSOAPBinding {
    private MessageFactory msgFactory = SOAPUtils.newSOAP11MessageFactory();

    @Override
    protected SOAPMessage createMessage(OperationMetaData opMetaData) throws SOAPException {
        SOAPMessage soapMessage = this.msgFactory.createMessage();
        Use encStyle = opMetaData.getEndpointMetaData().getEncodingStyle();
        if (Use.ENCODED.equals(encStyle)) {
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            soapEnvelope.addNamespaceDeclaration("soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");
        }
        return soapMessage;
    }

    public abstract Set<String> getRoles();

    @Override
    protected void verifyUnderstoodHeader(SOAPHeaderElement element) throws Exception {
        boolean isActor;
        QName name = new QName(element.getNamespaceURI(), element.getLocalName());
        String actor = element.getActor();
        Set<String> roles = this.getRoles();
        boolean bl = isActor = actor == null || actor.length() == 0 || "http://schemas.xmlsoap.org/soap/actor/next".equals(actor) || roles.contains(actor);
        if (isActor && !this.headerSource.getHeaders().contains(name)) {
            QName faultCode = Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND;
            String faultString = "Unprocessed 'mustUnderstand' header element: " + element.getElementName();
            SOAPFaultImpl fault = new SOAPFaultImpl();
            fault.setFaultCode(faultCode);
            fault.setFaultString(faultString);
            this.throwFaultException(fault);
        }
    }
}

