/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.util.Map;
import java.util.Properties;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

public class EndpointInfo {
    private String targetAddress;
    private Map<String, Object> properties;

    public EndpointInfo(EndpointMetaData epMetaData, String targetAddress, Map<String, Object> callProps) {
        this.targetAddress = this.lowerCaseProtocol(targetAddress);
        this.properties = callProps;
        Properties serviceProps = epMetaData.getServiceMetaData().getProperties();
        if (serviceProps != null) {
            for (Map.Entry<Object, Object> entry : serviceProps.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                this.properties.put(key, val);
            }
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EndpointInfo)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[addr=" + this.targetAddress + ",props=" + this.properties + "]";
    }

    private String lowerCaseProtocol(String targetAddress) {
        int colonIndex = targetAddress.indexOf(58);
        if (colonIndex == -1) {
            return targetAddress;
        }
        String lowerCasedProtocol = targetAddress.substring(0, colonIndex).toLowerCase();
        return lowerCasedProtocol + targetAddress.substring(colonIndex);
    }
}

