/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc;

import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.soap.utils.MessageContextAssociation;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;

public class SerializationContextJAXRPC
extends SerializationContext {
    private static final Logger log = Logger.getLogger(SerializationContextJAXRPC.class);
    private JavaWsdlMapping jaxrpcMapping;

    public JavaWsdlMapping getJavaWsdlMapping() {
        if (this.jaxrpcMapping == null) {
            log.debug((Object)"Generate jaxrpcMapping from typeMapping");
            this.jaxrpcMapping = new JavaWsdlMapping();
            for (QName xmlType : this.getTypeMapping().getRegisteredXmlTypes()) {
                JavaXmlTypeMapping xmlTypeMapping;
                String packageType;
                Package packageObject;
                String packageName;
                String nsURI = xmlType.getNamespaceURI();
                if ("http://www.w3.org/2001/XMLSchema".equals(nsURI) || "http://www.jboss.org/jbossws/attachment/mimetype".equals(nsURI)) continue;
                Class javaType = this.getTypeMapping().getJavaType(xmlType);
                String javaTypeName = javaType.getName();
                Class componentType = javaType;
                while (componentType.isArray()) {
                    componentType = componentType.getComponentType();
                }
                if (JavaUtils.isPrimitive((Class)componentType)) {
                    componentType = JavaUtils.getWrapperType(componentType);
                }
                if (!(packageName = (packageObject = componentType.getPackage()) != null ? packageObject.getName() : "").equals(packageType = this.jaxrpcMapping.getPackageNameForNamespaceURI(nsURI))) {
                    PackageMapping packageMapping = new PackageMapping(this.jaxrpcMapping);
                    packageMapping.setNamespaceURI(nsURI);
                    packageMapping.setPackageType(packageName);
                    this.jaxrpcMapping.addPackageMapping(packageMapping);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Add package mapping: " + packageMapping));
                    }
                }
                if (javaType.isArray() || (xmlTypeMapping = this.jaxrpcMapping.getTypeMappingForQName(xmlType)) != null) continue;
                xmlTypeMapping = new JavaXmlTypeMapping(this.jaxrpcMapping);
                xmlTypeMapping.setQNameScope("complexType");
                xmlTypeMapping.setJavaType(javaTypeName);
                xmlTypeMapping.setRootTypeQName(xmlType);
                this.jaxrpcMapping.addJavaXmlTypeMappings(xmlTypeMapping);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Add type mapping: " + xmlTypeMapping));
            }
        }
        return this.jaxrpcMapping;
    }

    public void setJavaWsdlMapping(JavaWsdlMapping jaxrpcMapping) {
        this.jaxrpcMapping = jaxrpcMapping;
    }

    public XSModel getXsModel() {
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        assert (msgContext != null);
        OperationMetaData opMetaData = msgContext.getOperationMetaData();
        ServiceMetaData serviceMetaData = opMetaData.getEndpointMetaData().getServiceMetaData();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        return typesMetaData.getSchemaModel();
    }
}

