/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.Constants;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.SerializerSupport;
import org.jboss.ws.util.xml.BufferedStreamResult;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.NamedNodeMap;

public class CalendarSerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(CalendarSerializer.class);

    @Override
    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        String valueStr;
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        }
        if (Constants.TYPE_LITERAL_DATE.equals(xmlType)) {
            valueStr = SimpleTypeBindings.marshalDate((Calendar)((Calendar)value));
        } else if (Constants.TYPE_LITERAL_TIME.equals(xmlType)) {
            valueStr = SimpleTypeBindings.marshalTime((Calendar)((Calendar)value));
        } else if (Constants.TYPE_LITERAL_DATETIME.equals(xmlType)) {
            valueStr = SimpleTypeBindings.marshalDateTime((Calendar)((Calendar)value));
        } else {
            throw NativeMessages.MESSAGES.invalidXmlType(xmlType);
        }
        NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
        String xmlFragment = this.wrapValueStr(xmlName, valueStr, nsRegistry, null, attributes, true);
        return new BufferedStreamResult(xmlFragment);
    }
}

