/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.handler;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeLoggers;

public class HandlerWrapper
implements Handler {
    private static Logger log = Logger.getLogger(HandlerWrapper.class);
    public static final int DOES_NOT_EXIST = 0;
    public static final int METHOD_READY = 1;
    private static String[] stateNames = new String[]{"DOES_NOT_EXIST", "METHOD_READY"};
    private Handler delegate;
    private int state;

    public HandlerWrapper(Handler handler) {
        this.delegate = handler;
        this.state = 0;
    }

    public int getState() {
        return this.state;
    }

    public String getStateAsString() {
        return stateNames[this.state];
    }

    public QName[] getHeaders() {
        return this.delegate.getHeaders();
    }

    public void init(HandlerInfo config) throws JAXRPCException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init: " + this.delegate));
        }
        this.delegate.init(config);
        this.state = 1;
    }

    public void destroy() throws JAXRPCException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroy: " + this.delegate));
        }
        this.state = 0;
        this.delegate.destroy();
    }

    public boolean handleRequest(MessageContext msgContext) throws JAXRPCException, SOAPFaultException {
        if (this.state == 0) {
            NativeLoggers.JAXRPC_LOGGER.handlerDoesNotExistSkippingHandleRequest(this.delegate);
            return true;
        }
        try {
            return this.delegate.handleRequest(msgContext);
        }
        catch (RuntimeException e) {
            return this.handleRuntimeException(e);
        }
    }

    public boolean handleResponse(MessageContext msgContext) {
        if (this.state == 0) {
            NativeLoggers.JAXRPC_LOGGER.handlerDoesNotExistSkippingHandleResponse(this.delegate);
            return true;
        }
        try {
            return this.delegate.handleResponse(msgContext);
        }
        catch (RuntimeException e) {
            return this.handleRuntimeException(e);
        }
    }

    public boolean handleFault(MessageContext msgContext) {
        if (this.state == 0) {
            NativeLoggers.JAXRPC_LOGGER.handlerDoesNotExistSkippingHandleFault(this.delegate);
            return true;
        }
        try {
            return this.delegate.handleFault(msgContext);
        }
        catch (RuntimeException e) {
            return this.handleRuntimeException(e);
        }
    }

    private boolean handleRuntimeException(RuntimeException e) {
        if (!(e instanceof SOAPFaultException)) {
            NativeLoggers.JAXRPC_LOGGER.handlerTransitionToDoesNotExist();
            this.destroy();
        }
        throw e;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return "[state=" + this.getStateAsString() + ",handler=" + this.delegate + "]";
    }
}

