/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.Constants;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPBinding;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.DirectionHolder;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.jaxrpc.ServletEndpointContextImpl;
import org.jboss.ws.core.jaxrpc.handler.HandlerDelegateJAXRPC;
import org.jboss.ws.core.jaxrpc.handler.MessageContextJAXRPC;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.server.DelegatingInvocation;
import org.jboss.ws.core.server.ServerHandlerDelegate;
import org.jboss.ws.core.server.ServletRequestContext;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPMessageDispatcher;
import org.jboss.ws.core.soap.utils.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public class ServiceEndpointInvoker {
    private static final Logger log = Logger.getLogger(ServiceEndpointInvoker.class);
    protected Endpoint endpoint;
    protected CommonBindingProvider bindingProvider;
    protected ServerHandlerDelegate delegate;

    public void init(Endpoint endpoint) {
        this.endpoint = endpoint;
        ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
        if (sepMetaData == null) {
            throw NativeMessages.MESSAGES.cannotObtainEndpointMetaData(endpoint);
        }
        this.bindingProvider = new CommonBindingProvider(sepMetaData);
        this.delegate = new HandlerDelegateJAXRPC(sepMetaData);
    }

    public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        return this.delegate.callRequestHandlerChain(sepMetaData, type);
    }

    public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        return this.delegate.callResponseHandlerChain(sepMetaData, type);
    }

    public void closeHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        this.delegate.closeHandlerChain(sepMetaData, type);
    }

    public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        return this.delegate.callFaultHandlerChain(sepMetaData, type, ex);
    }

    public void invoke(InvocationContext invContext) throws Exception {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)msgContext.getEndpointMetaData();
        SOAPMessage reqMessage = msgContext.getSOAPMessage();
        DirectionHolder direction = new DirectionHolder(DirectionHolder.Direction.InBound);
        UnifiedHandlerMetaData.HandlerType[] handlerType = this.delegate.getHandlerTypeOrder();
        UnifiedHandlerMetaData.HandlerType[] faultType = this.delegate.getHandlerTypeOrder();
        try {
            boolean oneway = false;
            EndpointInvocation sepInv = null;
            OperationMetaData opMetaData = null;
            CommonBinding binding = this.bindingProvider.getCommonBinding();
            binding.setHeaderSource(this.delegate);
            boolean handlersPass = this.callRequestHandlerChain(sepMetaData, handlerType[0]);
            if (handlersPass) {
                opMetaData = this.getDispatchDestination(sepMetaData, reqMessage);
                msgContext.setOperationMetaData(opMetaData);
                oneway = opMetaData.isOneWay();
                if (binding instanceof CommonSOAPBinding) {
                    ((CommonSOAPBinding)binding).checkMustUnderstand(opMetaData);
                }
                sepInv = binding.unbindRequestMessage(opMetaData, reqMessage);
            }
            handlersPass = handlersPass && this.callRequestHandlerChain(sepMetaData, handlerType[1]);
            boolean bl = handlersPass = handlersPass && this.callRequestHandlerChain(sepMetaData, handlerType[2]);
            if (handlersPass) {
                if (msgContext.isModified()) {
                    log.debug((Object)"Handler modified payload, unbind message again");
                    reqMessage = msgContext.getSOAPMessage();
                    sepInv = binding.unbindRequestMessage(opMetaData, reqMessage);
                }
                Invocation inv = this.setupInvocation(this.endpoint, sepInv, invContext);
                InvocationHandler invHandler = this.endpoint.getInvocationHandler();
                try {
                    invHandler.invoke(this.endpoint, inv);
                }
                catch (InvocationTargetException th) {
                    Throwable targetEx = th.getTargetException();
                    throw targetEx instanceof Exception ? (Exception)targetEx : new UndeclaredThrowableException(targetEx);
                }
                sepInv = (EndpointInvocation)inv.getInvocationContext().getAttachment(EndpointInvocation.class);
                msgContext = this.processPivotInternal(msgContext, direction);
                SOAPMessage resMessage = binding.bindResponseMessage(opMetaData, sepInv);
                msgContext.setSOAPMessage(resMessage);
            } else {
                SOAPMessage resMessage = msgContext.getSOAPMessage();
                msgContext = this.processPivotInternal(msgContext, direction);
                msgContext.setSOAPMessage(resMessage);
            }
            if (!oneway) {
                handlersPass = this.callResponseHandlerChain(sepMetaData, handlerType[2]);
                faultType[2] = null;
                handlersPass = handlersPass && this.callResponseHandlerChain(sepMetaData, handlerType[1]);
                faultType[1] = null;
                handlersPass = handlersPass && this.callResponseHandlerChain(sepMetaData, handlerType[0]);
                faultType[0] = null;
            }
        }
        catch (Exception ex2) {
            RuntimeException ex2;
            this.processPivotInternal(msgContext, direction);
            CommonBinding binding = this.bindingProvider.getCommonBinding();
            try {
                binding.bindFaultMessage(ex2);
                boolean handlersPass = true;
                if (faultType[2] != null) {
                    boolean bl = handlersPass = handlersPass && this.callFaultHandlerChain(sepMetaData, faultType[2], ex2);
                }
                if (faultType[1] != null) {
                    boolean bl = handlersPass = handlersPass && this.callFaultHandlerChain(sepMetaData, faultType[1], ex2);
                }
                if (faultType[0] != null) {
                    handlersPass = handlersPass && this.callFaultHandlerChain(sepMetaData, faultType[0], ex2);
                }
            }
            catch (RuntimeException subEx) {
                NativeLoggers.ROOT_LOGGER.exceptionProcessingHandleFault(ex2);
                binding.bindFaultMessage(subEx);
                ex2 = subEx;
            }
            throw ex2;
        }
        finally {
            this.closeHandlerChain(sepMetaData, handlerType[2]);
            this.closeHandlerChain(sepMetaData, handlerType[1]);
            this.closeHandlerChain(sepMetaData, handlerType[0]);
        }
    }

    protected Invocation setupInvocation(Endpoint ep, EndpointInvocation epInv, InvocationContext invContext) throws Exception {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext instanceof SOAPMessageContextJAXRPC) {
            invContext.addAttachment(MessageContext.class, (Object)msgContext);
        }
        if (ServiceLifecycle.class.isAssignableFrom(ep.getTargetBeanClass()) && invContext instanceof ServletRequestContext) {
            ServletEndpointContextImpl servletEndpointContext = new ServletEndpointContextImpl((ServletRequestContext)invContext);
            invContext.addAttachment(ServletEndpointContext.class, (Object)servletEndpointContext);
        }
        invContext.addAttachment(EndpointInvocation.class, (Object)epInv);
        DelegatingInvocation wsInv = new DelegatingInvocation();
        wsInv.setInvocationContext(invContext);
        wsInv.setJavaMethod(this.getImplMethod(this.endpoint, epInv));
        wsInv.getInvocationContext().setTargetBean(this.getEndpointInstance());
        return wsInv;
    }

    private Object getEndpointInstance() {
        Endpoint endpoint = this.endpoint;
        synchronized (endpoint) {
            try {
                String endpointClassName = this.endpoint.getTargetBeanName();
                return this.endpoint.getInstanceProvider().getInstance(endpointClassName).getValue();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    protected Method getImplMethod(Endpoint endpoint, EndpointInvocation sepInv) throws ClassNotFoundException, NoSuchMethodException {
        Class implClass = endpoint.getTargetBeanClass();
        Method seiMethod = sepInv.getJavaMethod();
        Method implMethod = null;
        if (seiMethod != null) {
            String methodName = seiMethod.getName();
            Class<?>[] paramTypes = seiMethod.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                Class paramType = paramTypes[i];
                if (JavaUtils.isPrimitive(paramType)) continue;
                String paramTypeName = paramType.getName();
                paramTypes[i] = paramType = JavaUtils.loadJavaType((String)paramTypeName);
            }
            implMethod = implClass.getMethod(methodName, paramTypes);
        } else {
            log.debug((Object)"RM method returned as null");
        }
        return implMethod;
    }

    private CommonMessageContext processPivotInternal(CommonMessageContext msgContext, DirectionHolder direction) {
        if (direction.getDirection() == DirectionHolder.Direction.InBound) {
            msgContext = MessageContextJAXRPC.processPivot(msgContext);
            direction.setDirection(DirectionHolder.Direction.OutBound);
        }
        return msgContext;
    }

    private OperationMetaData getDispatchDestination(EndpointMetaData epMetaData, SOAPMessage reqMessage) throws SOAPException {
        SOAPMessage soapMessage = reqMessage;
        OperationMetaData opMetaData = this.getOperationMetaData(epMetaData, soapMessage);
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        if (opMetaData == null) {
            QName faultCode;
            String faultString;
            SOAPBodyImpl soapBody = (SOAPBodyImpl)soapMessage.getSOAPBody();
            SOAPBodyElement soapBodyElement = soapBody.getBodyElement();
            if (soapBodyElement != null) {
                Name soapName = soapBodyElement.getElementName();
                faultString = "Endpoint " + epMetaData.getPortName() + " does not contain operation meta data for: " + soapName;
            } else {
                faultString = "Endpoint " + epMetaData.getPortName() + " does not contain operation meta data for empty soap body";
            }
            if (soapHeader != null && soapHeader.examineMustUnderstandHeaderElements("http://schemas.xmlsoap.org/soap/actor/next").hasNext()) {
                faultCode = Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND;
                throw new CommonSOAPFaultException(faultCode, faultString);
            }
            faultCode = Constants.SOAP11_FAULT_CODE_CLIENT;
            throw new CommonSOAPFaultException(faultCode, faultString);
        }
        return opMetaData;
    }

    public OperationMetaData getOperationMetaData(EndpointMetaData epMetaData, SOAPMessage soapMsg) throws SOAPException {
        SOAPMessageDispatcher dispatcher = new SOAPMessageDispatcher();
        return dispatcher.getDispatchDestination(epMetaData, soapMsg);
    }
}

