/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.common.Constants;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.soap.BundleUtils;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPHeaderImpl;
import org.jboss.ws.core.soap.SOAPPartImpl;
import org.w3c.dom.Document;

public class SOAPEnvelopeImpl
extends SOAPElementImpl
implements SOAPEnvelope {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SOAPEnvelopeImpl.class);
    private SOAPPartImpl soapPart;

    public SOAPEnvelopeImpl(SOAPPartImpl soapPart, SOAPElementImpl element, boolean addHeaderAndBody) throws SOAPException {
        super(element);
        this.soapPart = soapPart;
        soapPart.setEnvelope(this);
        String prefix = this.getPrefix();
        String namespaceURI = this.getNamespaceURI();
        String localName = this.getLocalName();
        if (!"Envelope".equals(localName)) {
            throw new IllegalArgumentException(BundleUtils.getMessage(bundle, "CANNOT_CREATE_SOAP_ENVELOPE", element.getElementQName()));
        }
        this.assertEnvelopeNamespace(namespaceURI);
        this.addNamespaceDeclaration(prefix, namespaceURI);
        if (addHeaderAndBody) {
            this.addHeader();
            this.addBody();
        }
    }

    SOAPEnvelopeImpl(SOAPPartImpl soapPart, String namespace, boolean addHeaderAndBody) throws SOAPException {
        super("Envelope", "env", namespace);
        this.soapPart = soapPart;
        soapPart.setEnvelope(this);
        this.assertEnvelopeNamespace(namespace);
        this.addNamespaceDeclaration(this.getPrefix(), namespace);
        if (addHeaderAndBody) {
            this.addHeader();
            this.addBody();
        }
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapPart.getSOAPMessage();
    }

    public SOAPBody addBody() throws SOAPException {
        SOAPBody body = this.getBody();
        if (body != null) {
            throw new SOAPException(BundleUtils.getMessage(bundle, "SOAPENVELOPE_ALREADY_HAS_A_BODY_ELEMENT", new Object[0]));
        }
        body = new SOAPBodyImpl(this.getPrefix(), this.getNamespaceURI());
        this.addChildElement((SOAPElement)body);
        return body;
    }

    public SOAPHeader addHeader() throws SOAPException {
        SOAPHeader header = this.getHeader();
        if (header != null) {
            throw new SOAPException(BundleUtils.getMessage(bundle, "SOAPENVELOPE_ALREADY_HAS_A_HEADER_ELEMENT", new Object[0]));
        }
        header = new SOAPHeaderImpl(this.getPrefix(), this.getNamespaceURI());
        return (SOAPHeader)this.addChildElement((SOAPElement)header);
    }

    @Override
    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        String envNamespace = this.getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(envNamespace) && name.equals(new NameImpl("encodingStyle", "env", envNamespace))) {
            throw new SOAPException(BundleUtils.getMessage(bundle, "CANNOT_SET_ENCODINGSTYLE", this.getElementQName()));
        }
        return super.addAttribute(name, value);
    }

    @Override
    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        String envNamespace = this.getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(envNamespace) && !(child instanceof SOAPHeader) && !(child instanceof SOAPBody)) {
            throw new SOAPException(BundleUtils.getMessage(bundle, "SOAPHEADER_OR_SOAPBODY_EXPECTED", new Object[0]));
        }
        return super.addChildElement(child);
    }

    public Name createName(String localName) throws SOAPException {
        return new NameImpl(localName);
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new NameImpl(localName, prefix, uri);
    }

    public SOAPBody getBody() throws SOAPException {
        return (SOAPBody)this.getFirstChildElementByLocalName("Body");
    }

    public SOAPHeader getHeader() throws SOAPException {
        return (SOAPHeader)this.getFirstChildElementByLocalName("Header");
    }

    @Override
    public SOAPElement addTextNode(String value) throws SOAPException {
        if (value.trim().length() > 0) {
            throw new SOAPException(BundleUtils.getMessage(bundle, "CANNOT_ADD_TEXT_NODE_TO_SOAPENVELOPE", new Object[0]));
        }
        return super.addTextNode(value);
    }

    @Override
    public Document getOwnerDocument() {
        return this.soapPart;
    }

    private void assertEnvelopeNamespace(String namespaceURI) {
        if (!"http://www.w3.org/2003/05/soap-envelope".equals(namespaceURI) && !"http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) {
            QName faultCode = Constants.SOAP11_FAULT_CODE_VERSION_MISMATCH;
            String faultString = "Invalid SOAP envelope namespace: " + namespaceURI;
            throw new CommonSOAPFaultException(faultCode, faultString);
        }
    }
}

