/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.client.UnMarshaller;
import org.jboss.ws.core.soap.BundleUtils;
import org.jboss.ws.core.soap.MessageFactoryImpl;

public class SOAPMessageUnMarshallerHTTP
implements UnMarshaller {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SOAPMessageUnMarshallerHTTP.class);
    private static Logger log = Logger.getLogger(SOAPMessageUnMarshallerHTTP.class);
    private static List<Integer> validResponseCodes = new ArrayList<Integer>();

    @Override
    public Object read(InputStream inputStream, Map<String, Object> metadata, Map<String, Object> headers) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read input stream with metadata=" + metadata));
        }
        try {
            Integer resCode = (Integer)metadata.get("org.jboss.ws.core.client.transport.NettyClient#ResponseCode");
            if (resCode == null) {
                log.warn((Object)BundleUtils.getMessage(bundle, "NO_HTTP_RESONSE_CODE", new Object[0]));
                resCode = 200;
            }
            String resMessage = (String)metadata.get("org.jboss.ws.core.client.transport.NettyClient#ResponseCodeMessage");
            if (!validResponseCodes.contains(resCode)) {
                throw new WSException(BundleUtils.getMessage(bundle, "INVALID_HTTP_SERVER_RESPONSE", resCode, resMessage));
            }
            SOAPMessage soapMsg = null;
            if (resCode != 204) {
                MimeHeaders mimeHeaders = this.getMimeHeaders(headers);
                soapMsg = this.getMessageFactory().createMessage(mimeHeaders, inputStream, false);
            }
            return soapMsg;
        }
        catch (SOAPException e) {
            log.error((Object)BundleUtils.getMessage(bundle, "CANNOT_UNMARSHALL_SOAPMESSAGE", new Object[0]), (Throwable)e);
            IOException e2 = new IOException(e.toString());
            e2.initCause(e);
            throw e2;
        }
    }

    protected MessageFactoryImpl getMessageFactory() {
        return new MessageFactoryImpl();
    }

    private MimeHeaders getMimeHeaders(Map<String, Object> metadata) {
        MimeHeaders headers = new MimeHeaders();
        for (String key : metadata.keySet()) {
            Object value = metadata.get(key);
            if (key == null || !(value instanceof List)) continue;
            for (Object listValue : (List)value) {
                headers.addHeader(key, listValue.toString());
            }
        }
        return headers;
    }

    static {
        validResponseCodes.add(200);
        validResponseCodes.add(202);
        validResponseCodes.add(204);
        validResponseCodes.add(500);
    }
}

