/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.attachment;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ResourceBundle;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.core.soap.BundleUtils;

public class XmlDataContentHandler
implements DataContentHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(XmlDataContentHandler.class);
    private DataFlavor[] flavors = new ActivationDataFlavor[]{new ActivationDataFlavor(StreamSource.class, "text/xml", "XML"), new ActivationDataFlavor(StreamSource.class, "application/xml", "XML")};

    public Object getContent(DataSource ds) throws IOException {
        return new StreamSource(ds.getInputStream());
    }

    public Object getTransferData(DataFlavor df, DataSource ds) throws UnsupportedFlavorException, IOException {
        return this.getContent(ds);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (!mimeType.startsWith("text/xml") && !mimeType.startsWith("application/xml")) {
            throw new IOException(BundleUtils.getMessage(bundle, "EXPECTED_TEXT_XML", mimeType));
        }
        if (!(obj instanceof StreamSource)) {
            throw new IOException(BundleUtils.getMessage(bundle, "ONLY_SUPPORTS_STREAMSOURCE", new Object[0]));
        }
        InputStream stream = ((StreamSource)obj).getInputStream();
        if (stream != null) {
            IOUtils.copyStream((OutputStream)os, (InputStream)stream);
        } else {
            IOUtils.copyReader((OutputStream)os, (Reader)((StreamSource)obj).getReader());
        }
    }
}

