/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.utils;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.core.soap.SOAPConnectionFactoryImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;

public final class SOAPUtils {
    private SOAPUtils() {
    }

    public static MessageFactory newSOAP11MessageFactory() {
        return SOAPUtils.newMessageFactory("SOAP 1.1 Protocol");
    }

    public static MessageFactory newSOAP12MessageFactory() {
        return SOAPUtils.newMessageFactory("SOAP 1.2 Protocol");
    }

    private static MessageFactory newMessageFactory(String protocol) {
        try {
            return new MessageFactoryImpl(protocol);
        }
        catch (SOAPException ignore) {
            return null;
        }
    }

    public static SOAPFactory newSOAP11Factory() {
        return SOAPUtils.newSOAPFactory("SOAP 1.1 Protocol");
    }

    public static SOAPFactory newSOAP12Factory() {
        return SOAPUtils.newSOAPFactory("SOAP 1.2 Protocol");
    }

    public static SOAPConnectionFactory newSOAPConnectionFactory() throws SOAPException {
        return new SOAPConnectionFactoryImpl();
    }

    public static SOAPBodyElement getFirstSOAPBodyElement(SOAPBody soapBody) {
        SOAPBodyElement bodyElement = null;
        Iterator it = soapBody.getChildElements();
        while (bodyElement == null && it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof SOAPBodyElement)) continue;
            bodyElement = (SOAPBodyElement)next;
        }
        return bodyElement;
    }

    private static SOAPFactory newSOAPFactory(String protocol) {
        try {
            return new SOAPFactoryImpl(protocol);
        }
        catch (SOAPException ignore) {
            return null;
        }
    }

    public static boolean isFaultMessage(SOAPMessage msg) {
        try {
            return msg.getSOAPBody().getFault() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Name newName(QName faultCode, SOAPEnvelope soapEnvelope) throws SOAPException {
        return soapEnvelope.createName(faultCode.getLocalPart(), faultCode.getPrefix(), faultCode.getNamespaceURI());
    }

    public static QName toQName(Name name) {
        return new QName(name.getURI(), name.getLocalName(), name.getPrefix());
    }
}

