/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.common.JavaUtils;

public class MimeUtils {
    private static Map<String, Class<?>> mime2class = new HashMap();
    private static Map<Class<?>, String> class2mime = new HashMap();

    public static QName convertMimeTypeToXmlType(String mimeType) {
        StringBuilder mimeName = new StringBuilder(mimeType);
        int pos = mimeName.indexOf("/");
        if (pos == -1) {
            return null;
        }
        mimeName.setCharAt(pos, '_');
        return new QName("http://www.jboss.org/jbossws/attachment/mimetype", mimeName.toString());
    }

    public static String getBaseMimeType(String mimeType) {
        ContentType contentType;
        if (mimeType == null) {
            return null;
        }
        try {
            contentType = new ContentType(mimeType);
        }
        catch (ParseException e) {
            return null;
        }
        return contentType.getBaseType();
    }

    public static boolean isMemberOf(String mimeType, Set<?> mimeTypes) {
        if (mimeTypes.contains(mimeType)) {
            return true;
        }
        try {
            if (mimeTypes.contains(new ContentType(mimeType).getPrimaryType() + "/*")) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    public static Class<?> resolveClass(String mimeType) {
        Class<Object> cl = mime2class.get(mimeType);
        if (null == cl) {
            cl = DataHandler.class;
        }
        return cl;
    }

    public static String resolveMimeType(Object obj) {
        String mimeType = obj instanceof MimeMultipart ? ((MimeMultipart)obj).getContentType() : MimeUtils.resolveMimeType(obj.getClass());
        return mimeType;
    }

    public static String resolveMimeType(Class<?> clazz) {
        String mimeType = "application/octet-stream";
        for (Class<?> cl : class2mime.keySet()) {
            if (!JavaUtils.isAssignableFrom(cl, clazz)) continue;
            mimeType = class2mime.get(cl);
        }
        return mimeType;
    }

    public static ByteArrayConverter getConverterForJavaType(Class<?> targetClazz) {
        ByteArrayConverter converter = null;
        if (JavaUtils.isAssignableFrom(Image.class, targetClazz)) {
            converter = new ImageConverter();
        } else if (JavaUtils.isAssignableFrom(Source.class, targetClazz)) {
            converter = new SourceConverter();
        } else if (JavaUtils.isAssignableFrom(String.class, targetClazz)) {
            converter = new StringConverter();
        } else if (JavaUtils.isAssignableFrom(InputStream.class, targetClazz)) {
            converter = new StreamConverter();
        } else if (JavaUtils.isAssignableFrom(byte[].class, targetClazz)) {
            converter = new RealByteArrayConverter();
        }
        if (null == converter) {
            throw NativeMessages.MESSAGES.noByteArrayConverterFor(targetClazz.getName());
        }
        return converter;
    }

    public static ByteArrayConverter getConverterForContentType(String contentType) {
        ByteArrayConverter converter = null;
        if (contentType != null) {
            if ("image/jpeg".equals(contentType) || "image/jpg".equals(contentType)) {
                converter = new ImageConverter();
            } else if ("text/xml".equals(contentType) || "application/xml".equals(contentType)) {
                converter = new SourceConverter();
            } else if ("text/plain".equals(contentType)) {
                converter = new StringConverter();
            } else if ("application/octet-stream".equals(contentType)) {
                converter = new StreamConverter();
            }
        }
        if (null == converter) {
            throw NativeMessages.MESSAGES.noByteArrayConverterFor(contentType);
        }
        return converter;
    }

    static {
        mime2class.put("text/plain", String.class);
        mime2class.put("image/jpeg", Image.class);
        mime2class.put("text/xml", Source.class);
        mime2class.put("application/xml", Source.class);
        mime2class.put("application/octet-stream", DataHandler.class);
        class2mime.put(Image.class, "image/jpeg");
        class2mime.put(Source.class, "text/xml");
        class2mime.put(String.class, "text/plain");
    }

    public static interface ByteArrayConverter {
        public Object readFrom(InputStream var1);

        public void writeTo(Object var1, OutputStream var2);
    }

    public static class StreamConverter
    implements ByteArrayConverter {
        @Override
        public Object readFrom(InputStream in) {
            return in;
        }

        @Override
        public void writeTo(Object obj, OutputStream out) {
            if (obj instanceof InputStream) {
                try {
                    IOUtils.copyStream((OutputStream)out, (InputStream)((InputStream)obj));
                }
                catch (IOException e) {
                    throw NativeMessages.MESSAGES.failedToConvert(obj.getClass());
                }
            }
        }
    }

    public static class RealByteArrayConverter
    implements ByteArrayConverter {
        @Override
        public Object readFrom(InputStream in) {
            byte[] converted = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copyStream((OutputStream)baos, (InputStream)in);
                in.close();
                converted = baos.toByteArray();
            }
            catch (IOException e) {
                throw NativeMessages.MESSAGES.failedToConvert("byte[]");
            }
            return converted;
        }

        @Override
        public void writeTo(Object obj, OutputStream out) {
            if (obj instanceof byte[]) {
                byte[] bytes = (byte[])obj;
                try {
                    out.write(bytes);
                }
                catch (IOException e) {
                    throw NativeMessages.MESSAGES.failedToConvert(obj.getClass());
                }
            } else {
                throw NativeMessages.MESSAGES.failedToConvert(obj.getClass());
            }
        }
    }

    public static class StringConverter
    implements ByteArrayConverter {
        @Override
        public Object readFrom(InputStream in) {
            String converted = null;
            try {
                int n;
                StringBuilder out = new StringBuilder();
                byte[] b = new byte[4096];
                while ((n = in.read(b)) != -1) {
                    out.append(new String(b, 0, n));
                }
                converted = out.toString();
            }
            catch (IOException e) {
                throw NativeMessages.MESSAGES.failedToConvert("java.lang.String");
            }
            return converted;
        }

        @Override
        public void writeTo(Object obj, OutputStream out) {
            if (obj instanceof String) {
                String s = (String)obj;
                try {
                    out.write(s.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    throw NativeMessages.MESSAGES.failedToConvert(obj.getClass());
                }
            } else {
                throw NativeMessages.MESSAGES.failedToConvert(obj.getClass());
            }
        }
    }

    public static class SourceConverter
    implements ByteArrayConverter {
        @Override
        public Object readFrom(InputStream in) {
            return new StreamSource(in);
        }

        @Override
        public void writeTo(Object obj, OutputStream out) {
            if (obj instanceof StreamSource) {
                StreamSource s = (StreamSource)obj;
                try {
                    IOUtils.copyStream((OutputStream)out, (InputStream)s.getInputStream());
                }
                catch (IOException e) {
                    throw NativeMessages.MESSAGES.failedToConvert(obj.getClass());
                }
            } else {
                throw NativeMessages.MESSAGES.failedToConvert(obj.getClass());
            }
        }
    }

    public static class ImageConverter
    implements ByteArrayConverter {
        @Override
        public Object readFrom(InputStream in) {
            BufferedImage converted = null;
            try {
                BufferedImage bim;
                ImageReader decoder = ImageIO.getImageReadersByFormatName("JPEG").next();
                ImageInputStream iis = ImageIO.createImageInputStream(in);
                decoder.setInput(iis);
                converted = bim = decoder.read(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return converted;
        }

        @Override
        public void writeTo(Object obj, OutputStream out) {
            if (obj instanceof BufferedImage) {
                ImageWriter encoder = ImageIO.getImageWritersByFormatName("JPEG").next();
                try {
                    ImageOutputStream ios = ImageIO.createImageOutputStream(out);
                    encoder.setOutput(ios);
                    encoder.write((BufferedImage)obj);
                }
                catch (IOException e) {
                    throw NativeMessages.MESSAGES.failedToConvert(obj.getClass());
                }
            } else {
                throw NativeMessages.MESSAGES.failedToConvert(obj.getClass());
            }
        }
    }
}

