/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.WSException;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.core.jaxrpc.UnqualifiedFaultException;
import org.jboss.ws.core.soap.utils.Use;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.HttpEndpoint;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;

public abstract class MetaDataBuilder {
    private static final Logger log = Logger.getLogger(MetaDataBuilder.class);

    protected void initEndpointBinding(WSDLEndpoint wsdlEndpoint, EndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = wsdlEndpoint.getWsdlService().getWsdlDefinitions();
        WSDLInterface wsdlInterface = wsdlEndpoint.getInterface();
        WSDLBinding wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(wsdlInterface.getName());
        this.initEndpointBinding(wsdlBinding, epMetaData);
    }

    protected void initEndpointBinding(WSDLBinding wsdlBinding, EndpointMetaData epMetaData) {
        String bindingType = wsdlBinding.getType();
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType)) {
            epMetaData.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http");
        } else if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) {
            epMetaData.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/");
        }
    }

    protected void initEndpointEncodingStyle(EndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = epMetaData.getServiceMetaData().getWsdlDefinitions();
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
                if (!epMetaData.getPortName().equals(wsdlEndpoint.getName())) continue;
                QName bindQName = wsdlEndpoint.getBinding();
                WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(bindQName);
                if (wsdlBinding == null) {
                    throw NativeMessages.MESSAGES.cannotObtainBinding(bindQName);
                }
                for (WSDLBindingOperation wsdlBindingOperation : wsdlBinding.getOperations()) {
                    String encStyle = wsdlBindingOperation.getEncodingStyle();
                    epMetaData.setEncodingStyle(Use.valueOf(encStyle));
                }
            }
        }
    }

    protected void initEndpointAddress(Deployment dep, ServerEndpointMetaData sepMetaData) {
        Integer port;
        Endpoint endpoint;
        String contextRoot = dep.getService().getContextRoot();
        String urlPattern = null;
        String linkName = sepMetaData.getLinkName();
        if (linkName != null && (endpoint = dep.getService().getEndpointByName(linkName)) != null) {
            urlPattern = ((HttpEndpoint)endpoint).getURLPattern();
        }
        if ((port = (Integer)dep.getService().getProperty("port")) == null) {
            port = -1;
        }
        if (contextRoot == null) {
            String simpleName = dep.getSimpleName();
            contextRoot = simpleName.substring(0, simpleName.indexOf(46));
            if (dep instanceof ArchiveDeployment && ((ArchiveDeployment)dep).getParent() != null) {
                simpleName = ((ArchiveDeployment)dep).getParent().getSimpleName();
                simpleName = simpleName.substring(0, simpleName.indexOf(46));
                contextRoot = simpleName + "-" + contextRoot;
            }
        }
        if (urlPattern == null) {
            urlPattern = "/*";
        }
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (!urlPattern.startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        sepMetaData.setContextRoot(contextRoot);
        sepMetaData.setURLPattern(urlPattern);
        String servicePath = contextRoot + urlPattern;
        sepMetaData.setEndpointAddress(MetaDataBuilder.getServiceEndpointAddress(null, servicePath, port, (ServerConfig)dep.getAttachment(ServerConfig.class)));
    }

    public static ObjectName createServiceEndpointID(Deployment dep, ServerEndpointMetaData sepMetaData) {
        String linkName = sepMetaData.getLinkName();
        String context = sepMetaData.getContextRoot();
        if (context.startsWith("/")) {
            context = context.substring(1);
        }
        StringBuilder idstr = new StringBuilder("jboss.ws:");
        idstr.append("context=" + context);
        idstr.append(",endpoint=" + linkName);
        return ObjectNameFactory.create((String)idstr.toString());
    }

    public static String getServiceEndpointAddress(String uriScheme, String servicePath, int servicePort, ServerConfig config) {
        if (servicePath == null || servicePath.length() == 0) {
            throw NativeMessages.MESSAGES.servicePathCannotBeNull();
        }
        if (servicePath.endsWith("/*")) {
            servicePath = servicePath.substring(0, servicePath.length() - 2);
        }
        if (uriScheme == null) {
            uriScheme = "http";
        }
        if (config == null) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        }
        String host = config.getWebServiceHost();
        int port = servicePort;
        if (servicePort == -1) {
            port = "https".equals(uriScheme) ? config.getWebServiceSecurePort() : config.getWebServicePort();
        }
        if ("http".equals(uriScheme) && port == 80 || "https".equals(uriScheme) && port == 443) {
            port = -1;
        }
        URL url = null;
        try {
            url = port > -1 ? new URL(uriScheme, host, port, servicePath) : new URL(uriScheme, host, servicePath);
            return url.toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new WSException(e);
        }
    }

    protected void initTransportGuaranteeJSE(Deployment dep, ServerEndpointMetaData sepMetaData, String servletLink) throws IOException {
        String transportGuarantee = null;
        JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
        if (webMetaData != null && WSHelper.isJseEndpoint((Endpoint)sepMetaData.getEndpoint())) {
            Map servletMappings = webMetaData.getServletMappings();
            String urlPattern = (String)servletMappings.get(servletLink);
            if (urlPattern == null) {
                throw NativeMessages.MESSAGES.cannotFindURLPatternForServletName(servletLink);
            }
            List securityList = webMetaData.getSecurityMetaData();
            for (JSESecurityMetaData currentSecurity : securityList) {
                if (currentSecurity.getTransportGuarantee() == null || currentSecurity.getTransportGuarantee().length() <= 0) continue;
                for (JSESecurityMetaData.JSEResourceCollection currentCollection : currentSecurity.getWebResources()) {
                    for (String currentUrlPattern : currentCollection.getUrlPatterns()) {
                        if (!urlPattern.equals(currentUrlPattern) && !"/*".equals(currentUrlPattern)) continue;
                        transportGuarantee = currentSecurity.getTransportGuarantee();
                    }
                }
            }
        }
        sepMetaData.setTransportGuarantee(transportGuarantee);
    }

    public static void replaceAddressLocation(ServerEndpointMetaData sepMetaData) {
        WSDLDefinitions wsdlDefinitions = sepMetaData.getServiceMetaData().getWsdlDefinitions();
        QName portName = sepMetaData.getPortName();
        boolean endpointFound = false;
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            for (WSDLEndpoint wsdlEndpoint : wsdlService.getEndpoints()) {
                ServerConfig config;
                QName wsdlPortName = wsdlEndpoint.getName();
                if (!wsdlPortName.equals(portName)) continue;
                endpointFound = true;
                String orgAddress = wsdlEndpoint.getAddress();
                String uriScheme = MetaDataBuilder.getUriScheme(orgAddress);
                String transportGuarantee = sepMetaData.getTransportGuarantee();
                if ("CONFIDENTIAL".equals(transportGuarantee)) {
                    uriScheme = "https";
                }
                if (MetaDataBuilder.requiresRewrite(orgAddress, uriScheme, config = (ServerConfig)sepMetaData.getEndpoint().getService().getDeployment().getAttachment(ServerConfig.class))) {
                    String servicePath = sepMetaData.getContextRoot() + sepMetaData.getURLPattern();
                    String serviceEndpointURL = MetaDataBuilder.getServiceEndpointAddress(uriScheme, servicePath, -1, config);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Replace service endpoint address '" + orgAddress + "' with '" + serviceEndpointURL + "'"));
                    }
                    wsdlEndpoint.setAddress(serviceEndpointURL);
                    sepMetaData.setEndpointAddress(serviceEndpointURL);
                    if (wsdlDefinitions.getWsdlOneOneDefinition() == null) continue;
                    MetaDataBuilder.replaceWSDL11PortAddress(wsdlDefinitions, portName, serviceEndpointURL);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Don't replace service endpoint address '" + orgAddress + "'"));
                }
                try {
                    sepMetaData.setEndpointAddress(new URL(orgAddress).toExternalForm());
                }
                catch (MalformedURLException e) {
                    NativeLoggers.ROOT_LOGGER.malformedURL(orgAddress);
                    sepMetaData.setEndpointAddress(orgAddress);
                }
            }
        }
        if (!endpointFound) {
            throw NativeMessages.MESSAGES.cannotFindPortInWsdl(portName);
        }
    }

    private static boolean requiresRewrite(String orgAddress, String uriScheme, ServerConfig config) {
        boolean alwaysModify;
        if (uriScheme != null && !uriScheme.toLowerCase().startsWith("http")) {
            return false;
        }
        if (config == null) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        }
        return (alwaysModify = config.isModifySOAPAddress()) || uriScheme == null || orgAddress.indexOf("REPLACE_WITH_ACTUAL_URL") >= 0;
    }

    private static void replaceWSDL11PortAddress(WSDLDefinitions wsdlDefinitions, QName portQName, String serviceEndpointURL) {
        Definition wsdlOneOneDefinition = wsdlDefinitions.getWsdlOneOneDefinition();
        String tnsURI = wsdlOneOneDefinition.getTargetNamespace();
        if (MetaDataBuilder.modifyPortAddress(tnsURI, portQName, serviceEndpointURL, wsdlOneOneDefinition.getServices())) {
            return;
        }
        if (!wsdlOneOneDefinition.getImports().isEmpty()) {
            for (List l : wsdlOneOneDefinition.getImports().values()) {
                for (Import anImport : l) {
                    if (!MetaDataBuilder.modifyPortAddress(anImport.getNamespaceURI(), portQName, serviceEndpointURL, anImport.getDefinition().getServices())) continue;
                    return;
                }
            }
        }
        throw NativeMessages.MESSAGES.cannotFindPortInWsdl2(portQName);
    }

    private static boolean modifyPortAddress(String tnsURI, QName portQName, String serviceEndpointURL, Map services) {
        for (Service wsdlOneOneService : services.values()) {
            Map wsdlOneOnePorts = wsdlOneOneService.getPorts();
            for (String portLocalName : wsdlOneOnePorts.keySet()) {
                if (!portQName.equals(new QName(tnsURI, portLocalName))) continue;
                Port wsdlOneOnePort = (Port)wsdlOneOnePorts.get(portLocalName);
                List extElements = wsdlOneOnePort.getExtensibilityElements();
                for (Object extElement : extElements) {
                    SOAPAddress address;
                    if (extElement instanceof SOAPAddress) {
                        address = (SOAPAddress)extElement;
                        address.setLocationURI(serviceEndpointURL);
                        continue;
                    }
                    if (extElement instanceof SOAP12Address) {
                        address = (SOAP12Address)extElement;
                        address.setLocationURI(serviceEndpointURL);
                        continue;
                    }
                    if (!(extElement instanceof HTTPAddress)) continue;
                    address = (HTTPAddress)extElement;
                    address.setLocationURI(serviceEndpointURL);
                }
                return true;
            }
        }
        return false;
    }

    private static String getUriScheme(String addrStr) {
        try {
            URI addrURI = new URI(addrStr);
            String scheme = addrURI.getScheme();
            return scheme;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected void buildFaultMetaData(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation) {
        TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        WSDLInterface wsdlInterface = wsdlOperation.getWsdlInterface();
        for (WSDLInterfaceOperationOutfault outFault : wsdlOperation.getOutfaults()) {
            TypeMappingMetaData tmMetaData;
            QName ref = outFault.getRef();
            WSDLInterfaceFault wsdlFault = wsdlInterface.getFault(ref);
            QName xmlName = wsdlFault.getElement();
            QName xmlType = wsdlFault.getXmlType();
            String javaTypeName = null;
            if (xmlType == null) {
                NativeLoggers.ROOT_LOGGER.cannotObtainFaultTypeForElement(xmlName);
                xmlType = xmlName;
            }
            if ((tmMetaData = typesMetaData.getTypeMappingByXMLType(xmlType)) != null) {
                javaTypeName = tmMetaData.getJavaTypeName();
            }
            if (javaTypeName == null) {
                NativeLoggers.ROOT_LOGGER.cannotObtainJavaTypeMappingFor(xmlType);
                javaTypeName = new UnqualifiedFaultException(xmlType).getClass().getName();
            }
            FaultMetaData faultMetaData = new FaultMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            opMetaData.addFault(faultMetaData);
        }
    }
}

