/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.WSException;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.metadata.umdm.InitalizableMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;

public class FaultMetaData
implements InitalizableMetaData {
    private final Logger log = Logger.getLogger(FaultMetaData.class);
    private OperationMetaData opMetaData;
    private QName xmlName;
    private QName xmlType;
    private String javaTypeName;
    private String faultBeanName;
    private Class<?> javaType;
    private Class<?> faultBean;
    private Method faultInfoMethod;
    private Constructor<?> serviceExceptionConstructor;
    private Method[] serviceExceptionGetters;
    private WrappedParameter[] faultBeanProperties;
    private Class<?>[] propertyTypes;

    public FaultMetaData(OperationMetaData operation, QName xmlName, QName xmlType, String javaTypeName) {
        this(operation, xmlName, javaTypeName);
        this.setXmlType(xmlType);
    }

    public FaultMetaData(OperationMetaData operation, QName xmlName, String javaTypeName) {
        if (xmlName == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("xmlName");
        }
        if (javaTypeName == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("javaTypeName");
        }
        this.opMetaData = operation;
        this.xmlName = xmlName;
        this.javaTypeName = javaTypeName;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public QName getXmlName() {
        return this.xmlName;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(QName xmlType) {
        if (xmlType == null) {
            throw NativeMessages.MESSAGES.illegalNullArgument("xmlType");
        }
        this.xmlType = xmlType;
    }

    public void setJavaTypeName(String javaTypeName) {
        this.javaTypeName = javaTypeName;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public Class<?> getJavaType() {
        if (this.javaType != null) {
            return this.javaType;
        }
        if (this.javaTypeName == null) {
            return null;
        }
        try {
            ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
            Class exceptionType = JavaUtils.loadJavaType((String)this.javaTypeName, (ClassLoader)loader);
            if (!Exception.class.isAssignableFrom(exceptionType)) {
                throw NativeMessages.MESSAGES.notAssignableToException(exceptionType);
            }
            if (this.opMetaData.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData().isEagerInitialized()) {
                NativeLoggers.ROOT_LOGGER.loadingJavaTypeAfterEagerInit();
                this.javaType = exceptionType;
            }
            return exceptionType;
        }
        catch (ClassNotFoundException ex) {
            throw new WSException(ex);
        }
    }

    public String getFaultBeanName() {
        return this.faultBeanName;
    }

    public void setFaultBeanName(String faultBeanName) {
        this.faultBeanName = faultBeanName;
    }

    public Class loadFaultBean() {
        Class faultBean = null;
        try {
            ClassLoader loader = this.getOperationMetaData().getEndpointMetaData().getClassLoader();
            faultBean = JavaUtils.loadJavaType((String)this.faultBeanName, (ClassLoader)loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return faultBean;
    }

    public Class getFaultBean() {
        Class tmpFaultBean = this.faultBean;
        if (tmpFaultBean == null && this.faultBeanName != null) {
            try {
                ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
                tmpFaultBean = JavaUtils.loadJavaType((String)this.faultBeanName, (ClassLoader)loader);
            }
            catch (ClassNotFoundException ex) {
                throw new WSException(ex);
            }
        }
        return tmpFaultBean;
    }

    public void validate() {
    }

    @Override
    public void eagerInitialize() {
        this.javaType = this.getJavaType();
        if (this.javaType == null) {
            throw NativeMessages.MESSAGES.cannotLoad(this.javaTypeName);
        }
        if (!JavaUtils.isAssignableFrom(Exception.class, this.javaType)) {
            throw NativeMessages.MESSAGES.notAnException(this.javaTypeName);
        }
    }

    public Object toFaultBean(Exception serviceException) {
        Object faultBeanInstance;
        block8: {
            try {
                if (this.faultInfoMethod != null) {
                    faultBeanInstance = this.faultInfoMethod.invoke((Object)serviceException, new Object[0]);
                    break block8;
                }
                try {
                    faultBeanInstance = this.faultBean.newInstance();
                }
                catch (InstantiationException e) {
                    throw new WSException(e);
                }
                for (int i = 0; i < this.serviceExceptionGetters.length; ++i) {
                    Object propertyValue = this.serviceExceptionGetters[i].invoke((Object)serviceException, new Object[0]);
                    WrappedParameter faultBeanProperty = this.faultBeanProperties[i];
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("copying from " + this.javaType.getSimpleName() + '.' + this.serviceExceptionGetters[i].getName() + " to " + this.faultBean.getSimpleName() + '.' + faultBeanProperty.getVariable() + "<->" + faultBeanProperty.getName() + ": " + propertyValue));
                    }
                    faultBeanProperty.accessor().set(faultBeanInstance, propertyValue);
                }
            }
            catch (IllegalAccessException e) {
                throw new WSException(e);
            }
            catch (InvocationTargetException e) {
                throw new WSException(e.getTargetException());
            }
        }
        return faultBeanInstance;
    }

    public Exception toServiceException(Object faultBean, String message) {
        Exception serviceException;
        try {
            if (this.faultInfoMethod != null) {
                serviceException = (Exception)this.serviceExceptionConstructor.newInstance(message, faultBean);
            } else {
                if (this.serviceExceptionConstructor == null) {
                    throw NativeMessages.MESSAGES.couldNotInstanciateServiceException(this.javaType.getSimpleName(), Arrays.toString(this.propertyTypes));
                }
                int propertyCount = this.faultBeanProperties.length;
                Object[] propertyValues = new Object[propertyCount];
                for (int i = 0; i < propertyCount; ++i) {
                    propertyValues[i] = this.faultBeanProperties[i].accessor().get(faultBean);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("constructing " + this.javaType.getSimpleName() + ": " + Arrays.toString(propertyValues)));
                }
                serviceException = (Exception)this.serviceExceptionConstructor.newInstance(propertyValues);
            }
        }
        catch (InstantiationException e) {
            throw new WSException(e);
        }
        catch (IllegalAccessException e) {
            throw new WSException(e);
        }
        catch (InvocationTargetException e) {
            throw new WSException(e.getTargetException());
        }
        return serviceException;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nFaultMetaData");
        buffer.append("\n xmlName=" + this.xmlName);
        buffer.append("\n xmlType=" + this.xmlType);
        buffer.append("\n javaType=" + this.javaTypeName);
        buffer.append("\n faultBean=" + this.faultBeanName);
        return buffer.toString();
    }
}

