/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.WSException;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.TypeMappingRegistryImpl;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.SchemaBindingBuilder;
import org.jboss.ws.core.soap.utils.Use;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.InitalizableMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.wsdl.WSDLDefinitionsFactory;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;

public class ServiceMetaData
implements InitalizableMetaData,
Serializable {
    private UnifiedMetaData wsMetaData;
    private Map<QName, EndpointMetaData> endpoints = new LinkedHashMap<QName, EndpointMetaData>();
    private QName serviceName;
    private String serviceRefName;
    private String wsdName;
    private URL wsdlLocation;
    private String wsdlFile;
    private URL mappingLocation;
    private String wsdlPublishLocation;
    private TypesMetaData types;
    private TypeMappingRegistry tmRegistry = new TypeMappingRegistryImpl();
    private SchemaBinding schemaBinding;
    private Properties properties;
    private Use encStyle;
    private String wsdlCacheKey;

    public ServiceMetaData(UnifiedMetaData wsMetaData, QName serviceName) {
        this.wsMetaData = wsMetaData;
        this.serviceName = serviceName;
        this.types = new TypesMetaData(this);
    }

    public UnifiedMetaData getUnifiedMetaData() {
        return this.wsMetaData;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public void setServiceRefName(String serviceRefName) {
        this.serviceRefName = serviceRefName;
    }

    public String getWebserviceDescriptionName() {
        return this.wsdName;
    }

    public void setWebserviceDescriptionName(String wsdName) {
        this.wsdName = wsdName;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public URL getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(URL wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getWsdlPublishLocation() {
        return this.wsdlPublishLocation;
    }

    public void setWsdlPublishLocation(String wsdlPublishLocation) {
        this.wsdlPublishLocation = wsdlPublishLocation;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public TypesMetaData getTypesMetaData() {
        return this.types;
    }

    public List<EndpointMetaData> getEndpoints() {
        return new ArrayList<EndpointMetaData>(this.endpoints.values());
    }

    public EndpointMetaData getEndpoint(QName portName) {
        return this.endpoints.get(portName);
    }

    public EndpointMetaData removeEndpoint(QName portName) {
        return this.endpoints.remove(portName);
    }

    public EndpointMetaData getEndpointByServiceEndpointInterface(String seiName) {
        EndpointMetaData epMetaData = null;
        for (EndpointMetaData epmd : this.endpoints.values()) {
            if (!seiName.equals(epmd.getServiceEndpointInterfaceName())) continue;
            if (epMetaData != null) {
                NativeLoggers.ROOT_LOGGER.multiplePossibleEndpointImplementingSEI(seiName);
            }
            epMetaData = epmd;
        }
        return epMetaData;
    }

    public void addEndpoint(EndpointMetaData epMetaData) {
        QName portName = epMetaData.getPortName();
        if (this.endpoints.get(portName) != null) {
            throw NativeMessages.MESSAGES.endpointMetadataMustBeUnique(portName);
        }
        this.endpoints.put(portName, epMetaData);
    }

    public URL getMappingLocation() {
        return this.mappingLocation;
    }

    public void setMappingLocation(URL mappingLocation) {
        this.mappingLocation = mappingLocation;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        JavaWsdlMapping javaWsdlMapping = null;
        if (this.mappingLocation != null && (javaWsdlMapping = this.wsMetaData.getMappingDefinition(this.mappingLocation.toExternalForm())) == null) {
            try {
                JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
                javaWsdlMapping = mappingFactory.parse(this.mappingLocation);
                this.wsMetaData.addMappingDefinition(this.mappingLocation.toExternalForm(), javaWsdlMapping);
            }
            catch (IOException e) {
                throw new WSException(e);
            }
        }
        return javaWsdlMapping;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        WSDLDefinitions wsdlDefinitions = null;
        URL wsdlURL = this.getWsdlFileOrLocation();
        if (wsdlURL != null) {
            if (this.wsdlCacheKey == null) {
                this.wsdlCacheKey = "#" + (this.wsdlLocation != null ? this.wsdlLocation : this.wsdlFile);
            }
            if ((wsdlDefinitions = this.wsMetaData.getWsdlDefinition(this.wsdlCacheKey)) == null) {
                WSDLDefinitionsFactory factory = WSDLDefinitionsFactory.newInstance();
                wsdlDefinitions = factory.parse(wsdlURL);
                this.wsMetaData.addWsdlDefinition(this.wsdlCacheKey, wsdlDefinitions);
            }
        }
        return wsdlDefinitions;
    }

    public URL getWsdlFileOrLocation() {
        URL wsdlURL = this.wsdlLocation;
        if (wsdlURL == null && this.wsdlFile != null) {
            try {
                wsdlURL = new URL(this.wsdlFile);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (wsdlURL == null) {
                try {
                    UnifiedVirtualFile vfsRoot = this.getUnifiedMetaData().getRootFile();
                    wsdlURL = vfsRoot.findChild(this.wsdlFile).toURL();
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return wsdlURL;
    }

    public TypeMappingImpl getTypeMapping() {
        Use encStyle = this.getEncodingStyle();
        TypeMappingImpl typeMapping = (TypeMappingImpl)this.tmRegistry.getTypeMapping(encStyle.toURI());
        if (typeMapping == null) {
            throw NativeMessages.MESSAGES.noTypeMapping(encStyle);
        }
        return typeMapping;
    }

    public Use getEncodingStyle() {
        if (this.encStyle == null) {
            if (this.endpoints.size() > 0) {
                for (EndpointMetaData epMetaData : this.endpoints.values()) {
                    if (this.encStyle == null) {
                        this.encStyle = epMetaData.getEncodingStyle();
                        continue;
                    }
                    if (this.encStyle.equals(epMetaData.getEncodingStyle())) continue;
                    throw NativeMessages.MESSAGES.conflictingEncodingStyles(this.encStyle, epMetaData.getEncodingStyle());
                }
            } else {
                this.encStyle = Use.LITERAL;
            }
        }
        return this.encStyle;
    }

    public SchemaBinding getSchemaBinding() {
        JavaWsdlMapping wsdlMapping = this.getJavaWsdlMapping();
        if (this.schemaBinding == null && this.getEncodingStyle() == Use.LITERAL && wsdlMapping != null) {
            JBossXSModel xsModel = this.types.getSchemaModel();
            SchemaBindingBuilder bindingBuilder = new SchemaBindingBuilder();
            this.schemaBinding = bindingBuilder.buildSchemaBinding(xsModel, wsdlMapping);
        }
        return this.schemaBinding;
    }

    public void validate() {
        for (EndpointMetaData epMetaData : this.endpoints.values()) {
            epMetaData.validate();
        }
    }

    @Override
    public void eagerInitialize() {
        JBossXSModel model;
        WSDLTypes types;
        WSDLDefinitions definitions = this.getWsdlDefinitions();
        if (definitions != null && (types = definitions.getWsdlTypes()) != null && (model = WSDLUtils.getSchemaModel(types)) != null) {
            model.eagerInitialize();
        }
        this.getJavaWsdlMapping();
        for (EndpointMetaData epMetaData : this.endpoints.values()) {
            epMetaData.eagerInitialize();
        }
        this.getSchemaBinding();
    }

    public void assertTargetNamespace(String targetNS) {
        if (!this.getServiceName().getNamespaceURI().equals(targetNS)) {
            throw NativeMessages.MESSAGES.notWsdlTargetNamespace(targetNS);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nServiceMetaData:");
        buffer.append("\n qname=" + this.serviceName);
        buffer.append("\n refName=" + this.serviceRefName);
        buffer.append("\n wsdName=" + this.wsdName);
        buffer.append("\n wsdlFile=" + this.wsdlFile);
        buffer.append("\n wsdlLocation=" + this.wsdlLocation);
        buffer.append("\n jaxrpcMapping=" + this.mappingLocation);
        buffer.append("\n publishLocation=" + this.wsdlPublishLocation);
        buffer.append("\n properties=" + this.properties);
        buffer.append("\n" + this.types);
        buffer.append("\n");
        for (EndpointMetaData epMetaData : this.endpoints.values()) {
            buffer.append(epMetaData);
        }
        return buffer.toString();
    }
}

