/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;

public class TypesMetaData {
    private static final Logger log = Logger.getLogger(TypesMetaData.class);
    private ServiceMetaData serviceMetaData;
    private List<TypeMappingMetaData> typeList = new ArrayList<TypeMappingMetaData>();
    private JBossXSModel schemaModel;

    public TypesMetaData(ServiceMetaData serviceMetaData) {
        this.serviceMetaData = serviceMetaData;
    }

    public ServiceMetaData getServiceMetaData() {
        return this.serviceMetaData;
    }

    public JBossXSModel getSchemaModel() {
        return this.schemaModel;
    }

    public void setSchemaModel(JBossXSModel model) {
        this.schemaModel = model;
    }

    public void addSchemaModel(JBossXSModel model) {
        if (this.schemaModel == null) {
            this.schemaModel = model;
        } else {
            this.schemaModel.merge(model);
        }
    }

    public List<TypeMappingMetaData> getTypeMappings() {
        return new ArrayList<TypeMappingMetaData>(this.typeList);
    }

    public void addTypeMapping(TypeMappingMetaData tmMetaData) {
        if (!this.typeList.contains(tmMetaData)) {
            log.trace((Object)("Add type mapping: " + tmMetaData));
            this.typeList.add(tmMetaData);
        }
    }

    public TypeMappingMetaData getTypeMappingByXMLType(QName xmlType) {
        XSTypeDefinition xsType;
        TypeMappingMetaData tmMetaData = null;
        for (TypeMappingMetaData aux : this.typeList) {
            boolean isElementScope = "element".equals(aux.getQNameScope());
            if (!aux.getXmlType().equals(xmlType) || isElementScope) continue;
            if (tmMetaData != null) {
                log.error((Object)(tmMetaData + "\n" + aux));
                throw NativeMessages.MESSAGES.ambiguousTypeMapping(xmlType);
            }
            tmMetaData = aux;
        }
        if (tmMetaData == null && this.schemaModel != null && (xsType = this.schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI())) instanceof XSSimpleTypeDefinition) {
            XSSimpleTypeDefinition itemType;
            QName xmlBaseType;
            XSSimpleTypeDefinition xsSimpleType = (XSSimpleTypeDefinition)xsType;
            String javaTypeName = null;
            if (xsSimpleType.getVariety() == 2 && (javaTypeName = new LiteralTypeMapping().getJavaTypeName(xmlBaseType = new QName((itemType = xsSimpleType.getItemType()).getNamespace(), itemType.getName()))) != null) {
                javaTypeName = javaTypeName + "[]";
            }
            for (XSTypeDefinition xsBaseType = xsType.getBaseType(); javaTypeName == null && xsBaseType != null; xsBaseType = xsBaseType.getBaseType()) {
                xmlBaseType = new QName(xsBaseType.getNamespace(), xsBaseType.getName());
                javaTypeName = new LiteralTypeMapping().getJavaTypeName(xmlBaseType);
            }
            if (javaTypeName != null) {
                tmMetaData = new TypeMappingMetaData(this, xmlType, javaTypeName);
                tmMetaData.setQNameScope("simpleType");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding a simpleType without jaxrpc-mapping: " + tmMetaData));
                }
                this.addTypeMapping(tmMetaData);
            } else {
                NativeLoggers.ROOT_LOGGER.cannotObtainJavaTypeName(xmlType);
            }
        }
        return tmMetaData;
    }

    public TypeMappingMetaData getTypeMappingByJavaType(String javaTypeName) {
        TypeMappingMetaData tmMetaData = null;
        for (TypeMappingMetaData aux : this.typeList) {
            if (!aux.getJavaTypeName().equals(javaTypeName)) continue;
            tmMetaData = aux;
        }
        return tmMetaData;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nTypesMetaData: ");
        for (TypeMappingMetaData tmd : this.typeList) {
            buffer.append("\n  " + tmd);
        }
        buffer.append("\n" + (this.schemaModel != null ? this.schemaModel.serialize() : "<schema/>"));
        return buffer.toString();
    }
}

