/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyMap<K, V>
implements Map<K, V> {
    private Map<K, V> delegate = Collections.emptyMap();

    private Map<K, V> createImplementation() {
        if (!(this.delegate instanceof HashMap)) {
            return new HashMap<K, V>(this.delegate);
        }
        return this.delegate;
    }

    @Override
    public void clear() {
        this.delegate = Collections.emptyMap();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public V put(K key, V value) {
        if (this.delegate.isEmpty()) {
            this.delegate = Collections.singletonMap(key, value);
            return null;
        }
        this.delegate = this.createImplementation();
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.delegate = this.createImplementation();
        this.delegate.putAll(t);
    }

    @Override
    public V remove(Object key) {
        this.delegate = this.createImplementation();
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }
}

