/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.threadpool;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.util.collection.WeakValueHashMap;
import org.jboss.util.loading.ClassLoaderSource;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jboss.util.threadpool.BasicTaskWrapper;
import org.jboss.util.threadpool.BasicThreadPoolMBean;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.RunnableTaskWrapper;
import org.jboss.util.threadpool.Task;
import org.jboss.util.threadpool.TaskWrapper;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.threadpool.ThreadPoolFullException;
import org.jboss.util.threadpool.ThreadPoolStoppedException;

public class BasicThreadPool
implements ThreadPool,
BasicThreadPoolMBean {
    private static final ThreadGroup JBOSS_THREAD_GROUP = new ThreadGroup("JBoss Pooled Threads");
    private static final Map threadGroups = Collections.synchronizedMap(new WeakValueHashMap());
    private static final AtomicInteger lastPoolNumber = new AtomicInteger(0);
    private static Logger log = Logger.getLogger(BasicThreadPool.class);
    private String name;
    private int poolNumber;
    private BlockingMode blockingMode = BlockingMode.ABORT;
    private ThreadPoolExecutor executor;
    private LinkedBlockingQueue queue;
    private ThreadGroup threadGroup;
    private ClassLoaderSource classLoaderSource;
    private ContextClassLoaderSwitcher classLoaderSwitcher;
    private AtomicInteger lastThreadNumber = new AtomicInteger(0);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private PriorityQueue<TimeoutInfo> tasksWithTimeouts = new PriorityQueue(13);
    private TimeoutMonitor timeoutTask;
    private boolean trace = log.isTraceEnabled();

    public BasicThreadPool() {
        this("ThreadPool");
    }

    public BasicThreadPool(String name) {
        this(name, JBOSS_THREAD_GROUP);
    }

    public BasicThreadPool(String name, ThreadGroup threadGroup) {
        ThreadPoolThreadFactory factory = new ThreadPoolThreadFactory();
        this.queue = new LinkedBlockingQueue(1024);
        this.executor = new RestoreTCCLThreadPoolExecutor(4, 4, 60L, TimeUnit.SECONDS, this.queue);
        this.executor.setThreadFactory(factory);
        this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        this.poolNumber = lastPoolNumber.incrementAndGet();
        this.setName(name);
        this.threadGroup = threadGroup;
    }

    @Override
    public void stop(boolean immediate) {
        log.debug((Object)("stop, immediate=" + immediate));
        this.stopped.set(true);
        if (immediate) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdown();
        }
    }

    @Override
    public void waitForTasks() throws InterruptedException {
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public void waitForTasks(long maxWaitTime) throws InterruptedException {
        this.executor.awaitTermination(maxWaitTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void runTaskWrapper(TaskWrapper wrapper) {
        if (this.trace) {
            log.trace((Object)("runTaskWrapper, wrapper=" + wrapper));
        }
        if (this.stopped.get()) {
            wrapper.rejectTask(new ThreadPoolStoppedException("Thread pool has been stopped"));
            return;
        }
        wrapper.acceptTask();
        long completionTimeout = wrapper.getTaskCompletionTimeout();
        if (completionTimeout > 0L) {
            this.checkTimeoutMonitor();
            TimeoutInfo info = new TimeoutInfo(wrapper, completionTimeout);
            this.tasksWithTimeouts.add(info);
        }
        int waitType = wrapper.getTaskWaitType();
        switch (waitType) {
            case 2: {
                this.executeOnThread(wrapper);
                break;
            }
            default: {
                this.execute(wrapper);
            }
        }
        this.waitForTask(wrapper);
    }

    @Override
    public void runTask(Task task) {
        BasicTaskWrapper wrapper = new BasicTaskWrapper(task);
        this.runTaskWrapper(wrapper);
    }

    @Override
    public void run(Runnable runnable) {
        this.run(runnable, 0L, 0L);
    }

    @Override
    public void run(Runnable runnable, long startTimeout, long completeTimeout) {
        RunnableTaskWrapper wrapper = new RunnableTaskWrapper(runnable, startTimeout, completeTimeout);
        this.runTaskWrapper(wrapper);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getPoolNumber() {
        return this.poolNumber;
    }

    @Override
    public String getThreadGroupName() {
        return this.threadGroup.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadGroupName(String threadGroupName) {
        ThreadGroup group;
        Map map = threadGroups;
        synchronized (map) {
            group = (ThreadGroup)threadGroups.get(threadGroupName);
            if (group == null) {
                group = new ThreadGroup(JBOSS_THREAD_GROUP, threadGroupName);
                threadGroups.put(threadGroupName, group);
            }
        }
        this.threadGroup = group;
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public int getMaximumQueueSize() {
        return this.queue.remainingCapacity() + this.queue.size();
    }

    @Override
    public void setMaximumQueueSize(int size) {
        ArrayList tmp = new ArrayList();
        this.queue.drainTo(tmp);
        this.queue = new LinkedBlockingQueue(size);
        this.queue.addAll(tmp);
        ThreadFactory tf = this.executor.getThreadFactory();
        RejectedExecutionHandler handler = this.executor.getRejectedExecutionHandler();
        long keepAlive = this.executor.getKeepAliveTime(TimeUnit.SECONDS);
        int cs = this.executor.getCorePoolSize();
        int mcs = this.executor.getMaximumPoolSize();
        this.executor = new ThreadPoolExecutor(cs, mcs, keepAlive, TimeUnit.SECONDS, this.queue);
        this.executor.setThreadFactory(tf);
        this.executor.setRejectedExecutionHandler(handler);
    }

    @Override
    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    @Override
    public int getMinimumPoolSize() {
        return this.executor.getCorePoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMinimumPoolSize(int size) {
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        synchronized (threadPoolExecutor) {
            if (this.executor.getMaximumPoolSize() < size) {
                this.executor.setCorePoolSize(size);
                this.executor.setMaximumPoolSize(size);
            }
        }
    }

    @Override
    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int size) {
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        synchronized (threadPoolExecutor) {
            this.executor.setCorePoolSize(size);
            this.executor.setMaximumPoolSize(size);
        }
    }

    @Override
    public long getKeepAliveTime() {
        return this.executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setKeepAliveTime(long time) {
        this.executor.setKeepAliveTime(time, TimeUnit.MILLISECONDS);
    }

    @Override
    public BlockingMode getBlockingMode() {
        return this.blockingMode;
    }

    @Override
    public void setBlockingMode(BlockingMode mode) {
        this.blockingMode = mode;
        if (this.blockingMode == BlockingMode.RUN) {
            this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        } else if (this.blockingMode == BlockingMode.WAIT) {
            this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        } else if (this.blockingMode == BlockingMode.DISCARD) {
            this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        } else if (this.blockingMode == BlockingMode.DISCARD_OLDEST) {
            this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
        } else if (this.blockingMode == BlockingMode.ABORT) {
            this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        } else {
            throw new IllegalArgumentException("Failed to recognize mode: " + mode);
        }
    }

    public void setBlockingMode(String name) {
        this.blockingMode = BlockingMode.toBlockingMode(name);
        if (this.blockingMode == null) {
            this.blockingMode = BlockingMode.ABORT;
        }
    }

    public void setBlockingModeString(String name) {
        this.blockingMode = BlockingMode.toBlockingMode(name);
        if (this.blockingMode == null) {
            this.blockingMode = BlockingMode.ABORT;
        }
    }

    @Override
    public ClassLoaderSource getClassLoaderSource() {
        return this.classLoaderSource;
    }

    @Override
    public void setClassLoaderSource(ClassLoaderSource classLoaderSource) {
        if (classLoaderSource == null) {
            this.classLoaderSource = null;
            this.classLoaderSwitcher = null;
        } else if (this.classLoaderSwitcher == null) {
            try {
                this.classLoaderSwitcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
                this.classLoaderSource = classLoaderSource;
            }
            catch (SecurityException e) {
                log.error((Object)"Cannot manage context classloader for pool threads; Do not have setContextClassLoader permission");
            }
        } else {
            this.classLoaderSource = classLoaderSource;
        }
    }

    @Override
    public ThreadPool getInstance() {
        return this;
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    public String toString() {
        return this.name + '(' + this.poolNumber + ')';
    }

    protected void executeOnThread(TaskWrapper wrapper) {
        if (this.trace) {
            log.trace((Object)("executeOnThread, wrapper=" + wrapper));
        }
        wrapper.run();
    }

    protected void execute(TaskWrapper wrapper) {
        if (this.trace) {
            log.trace((Object)("execute, wrapper=" + wrapper));
        }
        try {
            this.executor.execute(wrapper);
        }
        catch (Throwable t) {
            wrapper.rejectTask(new ThreadPoolFullException("Error scheduling work: " + wrapper, t));
        }
    }

    protected void waitForTask(TaskWrapper wrapper) {
        wrapper.waitForTask();
    }

    protected synchronized void checkTimeoutMonitor() {
        if (this.timeoutTask == null) {
            this.timeoutTask = new TimeoutMonitor(this.name, log);
        }
    }

    protected TimeoutInfo getNextTimeout() {
        TimeoutInfo info = null;
        if (!this.tasksWithTimeouts.isEmpty()) {
            info = (TimeoutInfo)this.tasksWithTimeouts.remove();
        }
        return info;
    }

    protected void setDefaultThreadContextClassLoader(Thread thread) {
        if (this.classLoaderSwitcher != null) {
            ClassLoader cl = this.classLoaderSource == null ? null : this.classLoaderSource.getClassLoader();
            this.classLoaderSwitcher.setContextClassLoader(thread, cl);
        }
    }

    private class TimeoutMonitor
    implements Runnable {
        final Logger log;

        TimeoutMonitor(String name, Logger log) {
            this.log = log;
            Thread t = new Thread((Runnable)this, name + " TimeoutMonitor");
            t.setDaemon(true);
            t.start();
        }

        @Override
        public void run() {
            boolean isStopped = BasicThreadPool.this.stopped.get();
            while (!isStopped) {
                boolean trace = this.log.isTraceEnabled();
                try {
                    TimeoutInfo info = BasicThreadPool.this.getNextTimeout();
                    if (info != null) {
                        TaskWrapper wrapper;
                        long now = System.currentTimeMillis();
                        long timeToTimeout = info.getTaskCompletionTimeout(now);
                        if (timeToTimeout > 0L) {
                            if (trace) {
                                this.log.trace((Object)("Will check wrapper=" + info.getTaskWrapper() + " after " + timeToTimeout));
                            }
                            Thread.sleep(timeToTimeout);
                        }
                        if (!(wrapper = info.getTaskWrapper()).isComplete()) {
                            if (trace) {
                                this.log.trace((Object)("Failed completion check for wrapper=" + wrapper));
                            }
                            if (info.stopTask()) {
                                info.setTimeout(1000L);
                                BasicThreadPool.this.tasksWithTimeouts.add(info);
                                if (trace) {
                                    this.log.trace((Object)("Rescheduled completion check for wrapper=" + wrapper));
                                }
                            }
                        }
                    } else {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    this.log.debug((Object)"Timeout monitor has been interrupted", (Throwable)e);
                }
                catch (Throwable e) {
                    this.log.debug((Object)"Timeout monitor saw unexpected error", e);
                }
                isStopped = BasicThreadPool.this.stopped.get();
            }
        }
    }

    private static class TimeoutInfo
    implements Comparable {
        long start = System.currentTimeMillis();
        long timeoutMS;
        TaskWrapper wrapper;
        boolean firstStop;

        TimeoutInfo(TaskWrapper wrapper, long timeout) {
            this.timeoutMS = this.start + timeout;
            this.wrapper = wrapper;
        }

        public void setTimeout(long timeout) {
            this.start = System.currentTimeMillis();
            this.timeoutMS = this.start + timeout;
        }

        public int compareTo(Object o) {
            TimeoutInfo ti = (TimeoutInfo)o;
            long to0 = this.timeoutMS;
            long to1 = ti.timeoutMS;
            return (int)(to0 - to1);
        }

        TaskWrapper getTaskWrapper() {
            return this.wrapper;
        }

        public long getTaskCompletionTimeout() {
            return this.wrapper.getTaskCompletionTimeout();
        }

        public long getTaskCompletionTimeout(long now) {
            return this.timeoutMS - now;
        }

        public boolean stopTask() {
            this.wrapper.stopTask();
            boolean wasFirstStop = !this.firstStop;
            this.firstStop = true;
            return wasFirstStop;
        }
    }

    private class RestoreTCCLThreadPoolExecutor
    extends ThreadPoolExecutor {
        public RestoreTCCLThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            try {
                super.afterExecute(r, t);
            }
            finally {
                BasicThreadPool.this.setDefaultThreadContextClassLoader(Thread.currentThread());
            }
        }
    }

    private class ThreadPoolThreadFactory
    implements ThreadFactory {
        private ThreadPoolThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String threadName = BasicThreadPool.this.toString() + "-" + BasicThreadPool.this.lastThreadNumber.incrementAndGet();
            Thread thread = new Thread(BasicThreadPool.this.threadGroup, runnable, threadName);
            thread.setDaemon(true);
            BasicThreadPool.this.setDefaultThreadContextClassLoader(thread);
            return thread;
        }
    }
}

