/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBClientProxyContext;
import org.jboss.ejb.client.remoting.RemotingAttachments;

final class RemotingSessionInterceptor
implements EJBClientInterceptor<RemotingAttachments> {
    public static final AttachmentKey<byte[]> SESSION_KEY = new AttachmentKey();

    RemotingSessionInterceptor() {
    }

    @Override
    public void handleInvocation(EJBClientInvocationContext<? extends RemotingAttachments> context) throws Throwable {
        context.getReceiverSpecific().putPayloadAttachment(0, context.getProxyAttachment(SESSION_KEY));
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext<? extends RemotingAttachments> context) throws Throwable {
        byte[] attachment = context.getReceiverSpecific().getPayloadAttachment(0);
        if (attachment != null && attachment.length > 0 && attachment[0] != 0) {
            context.removeProxyAttachment(SESSION_KEY);
        }
        return context.getResult();
    }

    @Override
    public void prepareSerialization(EJBClientProxyContext<? extends RemotingAttachments> context) {
        context.getReceiverSpecific().putPayloadAttachment(0, context.getProxyAttachment(SESSION_KEY));
    }

    @Override
    public void postDeserialize(EJBClientProxyContext<? extends RemotingAttachments> context) {
        context.putProxyAttachment(SESSION_KEY, context.getReceiverSpecific().getPayloadAttachment(0));
    }
}

