/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.marshalling.FieldSetter;

public abstract class EJBGenericHandle<T>
implements Serializable {
    private static final long serialVersionUID = -8321219873002436838L;
    private final Class<T> type;
    private final String appName;
    private final String moduleName;
    private final String distinctName;
    private final String beanName;
    private final transient int hashCode;
    private static final FieldSetter hashCodeSetter = FieldSetter.get(EJBGenericHandle.class, (String)"hashCode");

    EJBGenericHandle(Class<T> type, String appName, String moduleName, String distinctName, String beanName) {
        this.type = type;
        this.appName = appName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
        this.beanName = beanName;
        this.hashCode = EJBGenericHandle.calcHashCode(type, appName, moduleName, distinctName, beanName);
    }

    private static int calcHashCode(Class<?> type, String appName, String moduleName, String distinctName, String beanName) {
        return (((type.hashCode() * 13 + appName.hashCode()) * 13 + moduleName.hashCode()) * 13 + distinctName.hashCode()) * 13 + beanName.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof EJBGenericHandle && this.equals((EJBGenericHandle)other);
    }

    public boolean equals(EJBGenericHandle<?> other) {
        return this == other || other != null && this.type == other.type && this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.distinctName.equals(other.distinctName) && this.beanName.equals(other.beanName);
    }

    protected final T getProxy() {
        return this.type.cast(Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, (InvocationHandler)this.getInvocationHandler()));
    }

    protected EJBInvocationHandler getInvocationHandler() {
        return new EJBInvocationHandler(this.type, this.appName, this.moduleName, this.distinctName, this.beanName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        hashCodeSetter.setInt((Object)this, EJBGenericHandle.calcHashCode(this.type, this.appName, this.moduleName, this.distinctName, this.beanName));
    }
}

