/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBReceiverContext;

public abstract class EJBReceiver<A>
extends Attachable {
    private final Set<ModuleID> accessibleModules = Collections.synchronizedSet(new HashSet());

    protected final boolean registerModule(String appName, String moduleName, String distinctName) {
        return this.accessibleModules.add(new ModuleID(appName, moduleName, distinctName));
    }

    final boolean acceptsModule(String appName, String moduleName, String distinctName) {
        return this.accessibleModules.contains(new ModuleID(appName, moduleName, distinctName));
    }

    protected abstract void associate(EJBReceiverContext var1);

    protected abstract Future<?> processInvocation(EJBClientInvocationContext<A> var1, EJBReceiverContext var2) throws Exception;

    protected abstract byte[] openSession(EJBReceiverContext var1, String var2, String var3, String var4, String var5) throws Exception;

    protected abstract void verify(String var1, String var2, String var3, String var4) throws Exception;

    protected abstract A createReceiverSpecific();

    static class ModuleID {
        private final String appName;
        private final String moduleName;
        private final String distinctName;
        private final int hashCode;

        ModuleID(String appName, String moduleName, String distinctName) {
            if (moduleName == null) {
                throw new IllegalArgumentException("moduleName is null");
            }
            this.appName = appName == null ? moduleName : appName;
            this.moduleName = moduleName;
            this.distinctName = distinctName == null ? "" : distinctName;
            this.hashCode = this.appName.hashCode() + 31 * (this.moduleName.hashCode() + 31 * this.distinctName.hashCode());
        }

        public String getAppName() {
            return this.appName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getDistinctName() {
            return this.distinctName;
        }

        public boolean equals(Object other) {
            return other instanceof ModuleID && this.equals((ModuleID)other);
        }

        public boolean equals(ModuleID other) {
            return this == other || other != null && this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.distinctName.equals(other.distinctName);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

