/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.xnio.IoUtils;

class ResponseReceiver
implements Channel.Receiver {
    private static final Logger logger = Logger.getLogger(ResponseReceiver.class);
    private final RemotingConnectionEJBReceiver ejbReceiver;
    private final EJBReceiverContext ejbReceiverContext;

    ResponseReceiver(RemotingConnectionEJBReceiver ejbReceiver, EJBReceiverContext ejbReceiverContext) {
        this.ejbReceiver = ejbReceiver;
        this.ejbReceiverContext = ejbReceiverContext;
    }

    public void handleError(Channel channel, IOException error) {
    }

    public void handleEnd(Channel channel) {
    }

    public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
        DataInputStream inputStream = new DataInputStream((InputStream)messageInputStream);
        ProtocolMessageHandler messageHandler = null;
        try {
            byte header = inputStream.readByte();
            logger.info((Object)("Received message with header 0x" + Integer.toHexString(header)));
            messageHandler = this.ejbReceiver.getProtocolMessageHandler(this.ejbReceiverContext, header);
            if (messageHandler == null) {
                logger.warn((Object)("Unsupported message received with header 0x" + Integer.toHexString(header)));
                return;
            }
            messageHandler.readMessage(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            channel.receiveMessage((Channel.Receiver)this);
            IoUtils.safeClose((Closeable)inputStream);
        }
        if (messageHandler != null) {
            messageHandler.processMessage();
        }
    }
}

