/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.GeneralEJBClientInterceptor;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.remoting3.Connection;

public final class EJBClientContext
extends Attachable {
    private static final InheritableThreadLocal<EJBClientContext> CURRENT = new InheritableThreadLocal();
    static final GeneralEJBClientInterceptor[] GENERAL_INTERCEPTORS;
    private final Map<EJBReceiver<?>, EJBReceiverContext> ejbReceiverAssociations = new IdentityHashMap();

    EJBClientContext() {
    }

    public static EJBClientContext create() {
        if (CURRENT.get() != null) {
            throw new IllegalStateException("The current EJB client context is already set");
        }
        EJBClientContext ejbClientContext = new EJBClientContext();
        CURRENT.set(ejbClientContext);
        return ejbClientContext;
    }

    public static void setCurrent(EJBClientContext context) {
        if (CURRENT.get() != null) {
            throw new IllegalStateException("The current EJB client context is already set");
        }
        CURRENT.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EJBClientContext suspendCurrent() {
        try {
            EJBClientContext eJBClientContext = EJBClientContext.requireCurrent();
            return eJBClientContext;
        }
        finally {
            CURRENT.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EJBClientContext getAndSetCurrent(EJBClientContext context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        InheritableThreadLocal<EJBClientContext> tl = CURRENT;
        try {
            EJBClientContext eJBClientContext = (EJBClientContext)tl.get();
            return eJBClientContext;
        }
        finally {
            tl.set(context);
        }
    }

    public static void restoreCurrent(EJBClientContext current) {
        CURRENT.set(current);
    }

    public static EJBClientContext getCurrent() {
        return (EJBClientContext)CURRENT.get();
    }

    public static EJBClientContext requireCurrent() throws IllegalStateException {
        EJBClientContext clientContext = (EJBClientContext)CURRENT.get();
        if (clientContext == null) {
            throw new IllegalStateException("No EJB client context is set for this thread");
        }
        return clientContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEJBReceiver(EJBReceiver<?> receiver) {
        EJBReceiverContext ejbReceiverContext = null;
        Map<EJBReceiver<?>, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            if (this.ejbReceiverAssociations.containsKey(receiver)) {
                return;
            }
            ejbReceiverContext = new EJBReceiverContext(this);
            this.ejbReceiverAssociations.put(receiver, ejbReceiverContext);
        }
        receiver.associate(ejbReceiverContext);
    }

    public void registerConnection(Connection connection) {
        this.registerEJBReceiver(new RemotingConnectionEJBReceiver(connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<EJBReceiver<?>> getEJBReceivers(String appName, String moduleName, String distinctName) {
        HashSet eligibleEJBReceivers = new HashSet();
        Map<EJBReceiver<?>, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            for (EJBReceiver<?> ejbReceiver : this.ejbReceiverAssociations.keySet()) {
                if (!ejbReceiver.acceptsModule(appName, moduleName, distinctName)) continue;
                eligibleEJBReceivers.add(ejbReceiver);
            }
        }
        return eligibleEJBReceivers;
    }

    EJBReceiver<?> getEJBReceiver(String appName, String moduleName, String distinctName) {
        Iterator<EJBReceiver<?>> iterator = this.getEJBReceivers(appName, moduleName, distinctName).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBReceiver<?> requireEJBReceiver(String appName, String moduleName, String distinctName) throws IllegalStateException {
        EJBReceiver<?> ejbReceiver = null;
        Map<EJBReceiver<?>, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            if (this.ejbReceiverAssociations.size() == 1) {
                ejbReceiver = this.ejbReceiverAssociations.keySet().iterator().next();
            }
        }
        if (ejbReceiver != null) {
            return ejbReceiver;
        }
        ejbReceiver = this.getEJBReceiver(appName, moduleName, distinctName);
        if (ejbReceiver == null) {
            throw new IllegalStateException("No EJB receiver available for handling [appName:" + appName + ",modulename:" + moduleName + ",distinctname:" + distinctName + "] combination");
        }
        return ejbReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBReceiverContext requireEJBReceiverContext(EJBReceiver<?> receiver) throws IllegalStateException {
        Map<EJBReceiver<?>, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            EJBReceiverContext receiverContext = this.ejbReceiverAssociations.get(receiver);
            if (receiverContext == null) {
                throw new IllegalStateException(receiver + " has not been associated with " + this);
            }
            return receiverContext;
        }
    }

    EJBReceiver<?> getNodeEJBReceiver(String nodeName) {
        return null;
    }

    static {
        ArrayList<GeneralEJBClientInterceptor> interceptors = new ArrayList<GeneralEJBClientInterceptor>();
        for (GeneralEJBClientInterceptor interceptor : ServiceLoader.load(GeneralEJBClientInterceptor.class)) {
            interceptors.add(interceptor);
        }
        GENERAL_INTERCEPTORS = interceptors.toArray(new GeneralEJBClientInterceptor[interceptors.size()]);
    }
}

