/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.remoting.IntKeyMap;
import org.jboss.ejb.client.remoting.Marshaller;
import org.jboss.ejb.client.remoting.MarshallerFactory;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.RemotingAttachments;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;

class MethodInvocationMessageWriter {
    private static final byte METHOD_INVOCATION_HEADER = 3;
    private static final char METHOD_PARAM_TYPE_SEPARATOR = ',';
    private final RemotingConnectionEJBReceiver ejbReceiver;
    private final byte protocolVersion;
    private final String marshallingStrategy;

    MethodInvocationMessageWriter(RemotingConnectionEJBReceiver ejbReceiver, byte protocolVersion, String marshallingStrategy) {
        this.ejbReceiver = ejbReceiver;
        this.protocolVersion = protocolVersion;
        this.marshallingStrategy = marshallingStrategy;
    }

    public void writeMessage(DataOutput output, short invocationId, EJBClientInvocationContext<RemotingAttachments> invocationContext) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Cannot write to null output");
        }
        String appName = invocationContext.getAppName();
        String moduleName = invocationContext.getModuleName();
        String distinctName = invocationContext.getDistinctName();
        String beanName = invocationContext.getBeanName();
        String viewClassName = invocationContext.getViewClass().getName();
        Method invokedMethod = invocationContext.getInvokedMethod();
        Object[] methodParams = invocationContext.getParameters();
        output.writeByte(3);
        output.writeShort(invocationId);
        if (appName != null) {
            output.writeUTF(appName);
        } else {
            output.writeUTF("");
        }
        output.writeUTF(moduleName);
        if (distinctName != null) {
            output.writeUTF(distinctName);
        } else {
            output.writeUTF("");
        }
        output.writeUTF(beanName);
        output.writeUTF(viewClassName);
        output.writeUTF(invokedMethod.getName());
        Class<?>[] methodParamTypes = invokedMethod.getParameterTypes();
        StringBuffer methodSignature = new StringBuffer();
        for (int i = 0; i < methodParamTypes.length; ++i) {
            methodSignature.append(methodParamTypes[i].getName());
            if (i == methodParamTypes.length - 1) continue;
            methodSignature.append(',');
        }
        output.writeUTF(methodSignature.toString());
        this.writeAttachments(output, invocationContext.getReceiverSpecific());
        Marshaller marshaller = MarshallerFactory.createMarshaller(this.marshallingStrategy);
        marshaller.start(output);
        for (int i = 0; i < methodParams.length; ++i) {
            marshaller.writeObject(methodParams[i]);
        }
        marshaller.finish();
    }

    private void writeAttachments(DataOutput output, RemotingAttachments attachments) throws IOException {
        if (attachments == null) {
            output.writeByte(0);
            return;
        }
        output.writeByte(attachments.size());
        for (IntKeyMap.Entry<byte[]> attachment : attachments.entries()) {
            output.writeShort(attachment.getKey());
            byte[] data = attachment.getValue();
            PackedInteger.writePackedInteger(output, data.length);
            output.write(data);
        }
    }
}

