/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBClientTransactionContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.UserTransactionID;

public final class EJBClientUserTransactionContext
extends EJBClientTransactionContext {
    private static final ThreadLocal<State> CURRENT_TRANSACTION_STATE = new ThreadLocal();
    private static final AtomicInteger idCounter = new AtomicInteger(new Random().nextInt());

    @Override
    protected UserTransactionID associate(EJBClientInvocationContext<?> invocationContext) {
        State state = CURRENT_TRANSACTION_STATE.get();
        return state == null ? null : state.currentId;
    }

    public UserTransaction getUserTransaction(String nodeName) {
        return new UserTransactionImpl(nodeName);
    }

    class UserTransactionImpl
    implements UserTransaction {
        private final String nodeName;

        UserTransactionImpl(String nodeName) {
            this.nodeName = nodeName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void begin() throws NotSupportedException, SystemException {
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            if (state == null) {
                state = new State();
                CURRENT_TRANSACTION_STATE.set(state);
            }
            if (state.currentId != null) {
                throw new NotSupportedException("A transaction is already associated with this thread");
            }
            boolean ok = false;
            UserTransactionID transactionID = new UserTransactionID(this.nodeName, idCounter.getAndAdd(127));
            int timeout = state.timeout;
            try {
                EJBClientContext clientContext = EJBClientContext.requireCurrent();
                EJBReceiver<?> receiver = clientContext.getNodeEJBReceiver(this.nodeName);
            }
            finally {
                if (ok) {
                    state.currentId = transactionID;
                    state.status = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            if (state == null || state.currentId == null) {
                throw new IllegalStateException("A transaction is not associated with this thread");
            }
            if (state.status != 0 && state.status != 1) {
                throw new IllegalStateException("Transaction for this thread is not active");
            }
            UserTransactionID transactionID = new UserTransactionID(this.nodeName, idCounter.getAndAdd(127));
            try {
                EJBClientContext clientContext = EJBClientContext.requireCurrent();
                EJBReceiver<?> receiver = clientContext.getNodeEJBReceiver(this.nodeName);
                if (state.status == 1) {
                    state.status = 9;
                    throw new RollbackException("Transaction marked for rollback only");
                }
                state.status = 8;
            }
            finally {
                state.currentId = null;
                state.status = 6;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            if (state == null || state.currentId == null) {
                throw new IllegalStateException("A transaction is not associated with this thread");
            }
            if (state.status != 0 && state.status != 1) {
                throw new IllegalStateException("Transaction for this thread is not active");
            }
            UserTransactionID transactionID = new UserTransactionID(this.nodeName, idCounter.getAndAdd(127));
            try {
                EJBClientContext clientContext = EJBClientContext.requireCurrent();
                EJBReceiver<?> receiver = clientContext.getNodeEJBReceiver(this.nodeName);
                state.status = 9;
            }
            finally {
                state.currentId = null;
                state.status = 6;
            }
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            if (state != null) {
                switch (state.status) {
                    case 1: 
                    case 4: 
                    case 9: {
                        return;
                    }
                    case 0: {
                        state.status = 1;
                        return;
                    }
                }
            }
            throw new IllegalStateException("Transaction not active");
        }

        public int getStatus() throws SystemException {
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            return state == null ? 6 : state.status;
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            State state;
            if (seconds < 0) {
                seconds = 0;
            }
            if ((state = (State)CURRENT_TRANSACTION_STATE.get()) == null) {
                state = new State();
                CURRENT_TRANSACTION_STATE.set(state);
            }
            state.timeout = seconds;
        }
    }

    static class State {
        UserTransactionID currentId;
        int status = 6;
        int timeout = 0;

        State() {
        }
    }
}

