/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInput;
import java.io.IOException;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.RemotingAttachments;
import org.jboss.remoting3.MessageInputStream;

abstract class ProtocolMessageHandler {
    ProtocolMessageHandler() {
    }

    protected abstract void processMessage(MessageInputStream var1) throws IOException;

    protected RemotingAttachments readAttachments(DataInput input) throws IOException {
        int numAttachments = input.readByte();
        if (numAttachments == 0) {
            return null;
        }
        RemotingAttachments attachments = new RemotingAttachments();
        for (int i = 0; i < numAttachments; ++i) {
            short attachmentId = input.readShort();
            int dataLength = PackedInteger.readPackedInteger(input);
            byte[] data = new byte[dataLength];
            input.readFully(data);
            attachments.putPayloadAttachment(attachmentId, data);
        }
        return attachments;
    }

    short getInvocationId(DataInput input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Cannot read from null input");
        }
        return input.readShort();
    }
}

