/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jboss.ejb.client.Locator;
import org.jboss.marshalling.FieldSetter;

public abstract class EJBLocator<T>
extends Locator<T> {
    private static final long serialVersionUID = -7306257085240447972L;
    private final String appName;
    private final String moduleName;
    private final String beanName;
    private final String distinctName;
    private final transient int hashCode;
    private static final FieldSetter hashCodeSetter = FieldSetter.get(EJBLocator.class, (String)"hashCode");

    protected EJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName) {
        super(viewType);
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
        this.distinctName = distinctName;
        this.hashCode = EJBLocator.calcHashCode(super.hashCode(), appName, moduleName, beanName, distinctName);
    }

    private static int calcHashCode(int superHashCode, String appName, String moduleName, String beanName, String distinctName) {
        return superHashCode * 13 + (appName.hashCode() * 13 + (moduleName.hashCode() * 13 + (beanName.hashCode() * 13 + distinctName.hashCode())));
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public String getDistinctName() {
        return this.distinctName;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof EJBLocator && this.equals((EJBLocator)other);
    }

    @Override
    public boolean equals(Locator<?> other) {
        return other instanceof EJBLocator && this.equals((EJBLocator)other);
    }

    @Override
    public boolean equals(EJBLocator<?> other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.beanName.equals(other.beanName) && this.distinctName.equals(other.distinctName);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        hashCodeSetter.setInt((Object)this, EJBLocator.calcHashCode(super.hashCode(), this.appName, this.moduleName, this.beanName, this.distinctName));
    }
}

