/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Future;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.Locator;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.SerializedEJBInvocationHandler;

final class EJBInvocationHandler<T>
extends Attachable
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 946555285095057230L;
    private final transient boolean async;
    private final Locator<T> locator;

    EJBInvocationHandler(Locator<T> locator) {
        if (locator == null) {
            throw new NullPointerException("locator is null");
        }
        this.locator = locator;
        this.async = false;
    }

    EJBInvocationHandler(EJBInvocationHandler<T> other) {
        super(other);
        this.locator = other.locator;
        this.async = true;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.doInvoke(this.locator.getInterfaceType().cast(proxy), method, args);
    }

    Object doInvoke(T proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString") && method.getParameterTypes().length == 0) {
            return this.handleToString();
        }
        if (method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
            return this.handleEquals(args[0]);
        }
        if (method.getName().equals("hashCode") && method.getParameterTypes().length == 0) {
            return this.handleHashCode();
        }
        EJBClientContext context = EJBClientContext.requireCurrent();
        EJBReceiver<?> receiver = context.requireEJBReceiver(this.locator.getAppName(), this.locator.getModuleName(), this.locator.getDistinctName());
        return EJBInvocationHandler.doInvoke(this, this.async, proxy, method, args, receiver, context);
    }

    static <T> EJBInvocationHandler<? extends T> forProxy(T proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (handler instanceof EJBInvocationHandler) {
            return (EJBInvocationHandler)handler;
        }
        throw Logs.MAIN.proxyNotOurs(proxy, EJBClient.class.getName());
    }

    private static <T, A> Object doInvoke(EJBInvocationHandler<T> ejbInvocationHandler, boolean async, T proxy, Method method, Object[] args, EJBReceiver<A> receiver, EJBClientContext clientContext) throws Throwable {
        Object value;
        EJBReceiverContext ejbReceiverContext = clientContext.requireEJBReceiverContext(receiver);
        EJBClientInvocationContext<A> invocationContext = new EJBClientInvocationContext<A>(ejbInvocationHandler, clientContext, receiver.createReceiverSpecific(), receiver, ejbReceiverContext, proxy, method, args);
        invocationContext.sendRequest();
        if (!async && (value = invocationContext.awaitResponse()) != EJBClientInvocationContext.PROCEED_ASYNC) {
            return value;
        }
        if (method.getReturnType() == Future.class) {
            return invocationContext.getFutureResponse();
        }
        if (method.getReturnType() == Void.TYPE) {
            invocationContext.setDiscardResult();
            return null;
        }
        EJBClient.setFutureResult(invocationContext.getFutureResponse());
        return null;
    }

    private String handleToString() {
        return String.format("Proxy for remote EJB %s", this.locator);
    }

    private Integer handleHashCode() {
        return this.locator.hashCode();
    }

    private Boolean handleEquals(Object other) {
        InvocationHandler handler;
        if (other instanceof Proxy && (handler = Proxy.getInvocationHandler(other)) instanceof EJBInvocationHandler) {
            return this.locator.equals(((EJBInvocationHandler)handler).locator);
        }
        return Boolean.FALSE;
    }

    protected Object writeReplace() {
        return new SerializedEJBInvocationHandler(this.locator);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.async) {
            throw new NotSerializableException("Async proxies are not serializable");
        }
        oos.defaultWriteObject();
    }

    EJBInvocationHandler<T> getAsyncHandler() {
        return this.async ? this : new EJBInvocationHandler<T>(this);
    }

    Locator<T> getLocator() {
        return this.locator;
    }
}

