/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.util.Iterator;
import org.jboss.ejb.client.remoting.IntKeyMap;

public final class RemotingAttachments
implements Iterable<RemotingAttachment> {
    private final IntKeyMap<byte[]> payloadAttachments = new IntKeyMap();

    public byte[] getPayloadAttachment(int key) {
        if (key < 0 || key > 65535) {
            return null;
        }
        return this.payloadAttachments.get(key);
    }

    public byte[] putPayloadAttachment(int key, byte[] newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue is null");
        }
        if (key < 0 || key > 65535) {
            throw new IllegalArgumentException("Attachment key is out of range (must be 0-65535)");
        }
        return this.payloadAttachments.put(key, newValue);
    }

    public byte[] removePayloadAttachment(int key) {
        if (key < 0 || key > 65535) {
            return null;
        }
        return this.payloadAttachments.remove(key);
    }

    void clearPayloadAttachments() {
        this.payloadAttachments.clear();
    }

    public Iterable<RemotingAttachment> entries() {
        return this;
    }

    public int size() {
        return this.payloadAttachments.size();
    }

    @Override
    public Iterator<RemotingAttachment> iterator() {
        return new RemotingAttachmentIterator();
    }

    private class RemotingAttachmentIterator
    implements Iterator<RemotingAttachment> {
        private final Iterator<IntKeyMap.Entry<byte[]>> delegate;

        private RemotingAttachmentIterator() {
            this.delegate = RemotingAttachments.this.payloadAttachments.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public RemotingAttachment next() {
            IntKeyMap.Entry<byte[]> entry = this.delegate.next();
            if (entry == null) {
                return null;
            }
            return new RemotingAttachment(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported on " + this.getClass().getName());
        }
    }

    public static final class RemotingAttachment {
        private final int key;
        private final byte[] value;

        private RemotingAttachment(int key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }
    }
}

