/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBHandle;
import org.jboss.ejb.client.EJBHomeHandle;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.SerializedEJBInvocationHandler;

final class EJBInvocationHandler<T>
extends Attachable
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 946555285095057230L;
    private final transient boolean async;
    private final EJBLocator<T> locator;
    private static final Map<MethodKey, MethodHandler> clientSideMethods;

    EJBInvocationHandler(EJBLocator<T> locator) {
        if (locator == null) {
            throw new NullPointerException("locator is null");
        }
        this.locator = locator;
        this.async = false;
    }

    EJBInvocationHandler(EJBInvocationHandler<T> other) {
        super(other);
        this.locator = other.locator;
        this.async = true;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.doInvoke(this.locator.getViewType().cast(proxy), method, args);
    }

    Object doInvoke(T proxy, Method method, Object[] args) throws Throwable {
        MethodHandler handler = clientSideMethods.get(new MethodKey(method));
        if (handler != null && handler.canHandleInvocation(this, proxy, method, args)) {
            return handler.invoke(this, proxy, method, args);
        }
        EJBClientContext context = EJBClientContext.requireCurrent();
        EJBReceiver receiver = context.requireEJBReceiver(this.locator.getAppName(), this.locator.getModuleName(), this.locator.getDistinctName());
        return EJBInvocationHandler.doInvoke(this, this.async, proxy, method, args, receiver, context);
    }

    static <T> EJBInvocationHandler<? extends T> forProxy(T proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (handler instanceof EJBInvocationHandler) {
            return (EJBInvocationHandler)handler;
        }
        throw Logs.MAIN.proxyNotOurs(proxy, EJBClient.class.getName());
    }

    private static <T> Object doInvoke(EJBInvocationHandler<T> ejbInvocationHandler, boolean async, T proxy, Method method, Object[] args, EJBReceiver receiver, EJBClientContext clientContext) throws Throwable {
        Object value;
        EJBReceiverContext ejbReceiverContext = clientContext.requireEJBReceiverContext(receiver);
        EJBClientInvocationContext invocationContext = new EJBClientInvocationContext(ejbInvocationHandler, clientContext, receiver, ejbReceiverContext, proxy, method, args);
        invocationContext.sendRequest();
        if (!async && (value = invocationContext.awaitResponse()) != EJBClientInvocationContext.PROCEED_ASYNC) {
            return value;
        }
        if (method.getReturnType() == Future.class) {
            return invocationContext.getFutureResponse();
        }
        if (method.getReturnType() == Void.TYPE) {
            invocationContext.setDiscardResult();
            return null;
        }
        EJBClient.setFutureResult(invocationContext.getFutureResponse());
        return null;
    }

    protected Object writeReplace() {
        return new SerializedEJBInvocationHandler(this.locator);
    }

    EJBInvocationHandler<T> getAsyncHandler() {
        return this.async ? this : new EJBInvocationHandler<T>(this);
    }

    EJBLocator<T> getLocator() {
        return this.locator;
    }

    static {
        HashMap<MethodKey, MethodHandler> methods = new HashMap<MethodKey, MethodHandler>();
        methods.put(new MethodKey("equals", Object.class), new EqualsMethodHandler());
        methods.put(new MethodKey("hashCode", new Class[0]), new HashCodeMethodHandler());
        methods.put(new MethodKey("toString", new Class[0]), new ToStringMethodHandler());
        methods.put(new MethodKey("getPrimaryKey", new Class[0]), new GetPrimaryKeyHandler());
        methods.put(new MethodKey("getHandle", new Class[0]), new GetHandleHandler());
        methods.put(new MethodKey("isIdentical", EJBObject.class), new IsIdenticalHandler());
        methods.put(new MethodKey("getHomeHandle", new Class[0]), new GetHomeHandleHandler());
        clientSideMethods = Collections.unmodifiableMap(methods);
    }

    private static final class GetHomeHandleHandler
    implements MethodHandler {
        private GetHomeHandleHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            return proxy instanceof EJBHome;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            EJBLocator locator = thisHandler.getLocator();
            if (locator instanceof EJBHomeLocator) {
                return new EJBHomeHandle((EJBHomeLocator)locator);
            }
            throw new RemoteException("Cannot invoke getHomeHandle() on " + proxy);
        }
    }

    private static final class IsIdenticalHandler
    implements MethodHandler {
        private IsIdenticalHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            return proxy instanceof EJBObject && thisHandler.locator instanceof EJBLocator;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            InvocationHandler handler;
            EJBLocator locator = thisHandler.locator;
            Object other = args[0];
            if (Proxy.isProxyClass(other.getClass()) && (handler = Proxy.getInvocationHandler(other)) instanceof EJBInvocationHandler) {
                return locator.equals(((EJBInvocationHandler)handler).getLocator());
            }
            return false;
        }
    }

    private static final class GetHandleHandler
    implements MethodHandler {
        private GetHandleHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            return proxy instanceof EJBObject && thisHandler.locator instanceof EJBLocator;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            EJBLocator locator = thisHandler.getLocator();
            return new EJBHandle(locator);
        }
    }

    private static final class GetPrimaryKeyHandler
    implements MethodHandler {
        private GetPrimaryKeyHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            return proxy instanceof EJBObject;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) throws Exception {
            EJBLocator locator = thisHandler.locator;
            if (locator instanceof EntityEJBLocator) {
                return ((EntityEJBLocator)locator).getPrimaryKey();
            }
            throw new RemoteException("Cannot invoke getPrimaryKey() om " + proxy);
        }
    }

    private static final class ToStringMethodHandler
    implements MethodHandler {
        private ToStringMethodHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return true;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return String.format("Proxy for remote EJB %s", thisHandler.locator);
        }
    }

    private static final class HashCodeMethodHandler
    implements MethodHandler {
        private HashCodeMethodHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return true;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return thisHandler.locator.hashCode();
        }
    }

    private static final class EqualsMethodHandler
    implements MethodHandler {
        private EqualsMethodHandler() {
        }

        @Override
        public boolean canHandleInvocation(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            return true;
        }

        @Override
        public Object invoke(EJBInvocationHandler thisHandler, Object proxy, Method method, Object[] args) {
            InvocationHandler handler;
            Object other = args[0];
            if (other instanceof Proxy && (handler = Proxy.getInvocationHandler(other)) instanceof EJBInvocationHandler) {
                return thisHandler.locator.equals(((EJBInvocationHandler)handler).locator);
            }
            return Boolean.FALSE;
        }
    }

    private static interface MethodHandler {
        public boolean canHandleInvocation(EJBInvocationHandler var1, Object var2, Method var3, Object[] var4) throws Exception;

        public Object invoke(EJBInvocationHandler var1, Object var2, Method var3, Object[] var4) throws Exception;
    }

    private static final class MethodKey {
        private final String name;
        private final Class[] parameters;

        public MethodKey(String name, Class ... parameters) {
            this.name = name;
            this.parameters = parameters;
        }

        public MethodKey(Method method) {
            this.name = method.getName();
            this.parameters = method.getParameterTypes();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            if (!this.name.equals(methodKey.name)) {
                return false;
            }
            return Arrays.equals(this.parameters, methodKey.parameters);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.parameters);
            return result;
        }
    }
}

