/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.MethodInvocationMessageWriter;
import org.jboss.ejb.client.remoting.ModuleAvailabilityMessageHandler;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.SessionOpenRequestWriter;
import org.jboss.ejb.client.remoting.SessionOpenResponseHandler;
import org.jboss.ejb.client.remoting.TransactionMessageWriter;
import org.jboss.ejb.client.remoting.VersionReceiver;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public final class RemotingConnectionEJBReceiver
extends EJBReceiver {
    private static final Logger logger = Logger.getLogger(RemotingConnectionEJBReceiver.class);
    private static final String EJB_CHANNEL_NAME = "jboss.ejb";
    private final Connection connection;
    private final Map<EJBReceiverContext, ChannelAssociation> channelAssociations = new IdentityHashMap<EJBReceiverContext, ChannelAssociation>();
    private final byte clientProtocolVersion = 1;
    private final String clientMarshallingStrategy = "river";
    private final Map<EJBReceiverContext, CountDownLatch> moduleAvailabilityReportLatches = new IdentityHashMap<EJBReceiverContext, CountDownLatch>();
    private final String cachedToString;
    private final MarshallerFactory marshallerFactory;
    private final ReconnectHandler reconnectHandler;
    private final OptionMap channelCreationOptions;

    public RemotingConnectionEJBReceiver(Connection connection) {
        this(connection, null, OptionMap.EMPTY);
    }

    RemotingConnectionEJBReceiver(Connection connection, ReconnectHandler reconnectHandler, OptionMap channelCreationOptions) {
        super(connection.getRemoteEndpointName());
        this.connection = connection;
        this.reconnectHandler = reconnectHandler;
        this.channelCreationOptions = channelCreationOptions == null ? OptionMap.EMPTY : channelCreationOptions;
        this.cachedToString = new StringBuffer("Remoting connection EJB receiver [connection=").append(this.connection).append(",channel=").append(EJB_CHANNEL_NAME).append(",nodename=").append(this.getNodeName()).append("]").toString();
        this.marshallerFactory = Marshalling.getProvidedMarshallerFactory((String)this.clientMarshallingStrategy);
        if (this.marshallerFactory == null) {
            throw new RuntimeException("Could not find a marshaller factory for " + this.clientMarshallingStrategy + " marshalling strategy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associate(EJBReceiverContext context) {
        boolean successfulHandshake;
        CountDownLatch initialModuleAvailabilityLatch;
        block13: {
            CountDownLatch versionHandshakeLatch = new CountDownLatch(1);
            initialModuleAvailabilityLatch = new CountDownLatch(1);
            Map<EJBReceiverContext, CountDownLatch> map = this.moduleAvailabilityReportLatches;
            synchronized (map) {
                this.moduleAvailabilityReportLatches.put(context, initialModuleAvailabilityLatch);
            }
            final VersionReceiver versionReceiver = new VersionReceiver(versionHandshakeLatch, this.clientProtocolVersion, this.clientMarshallingStrategy);
            IoFuture futureChannel = this.connection.openChannel(EJB_CHANNEL_NAME, this.channelCreationOptions);
            futureChannel.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Channel, EJBReceiverContext>(){

                public void handleCancelled(EJBReceiverContext context) {
                    logger.debug((Object)("Channel open requested cancelled for context " + context));
                    context.close();
                }

                public void handleFailed(IOException exception, EJBReceiverContext context) {
                    logger.error((Object)("Failed to open channel for context " + context), (Throwable)exception);
                    context.close();
                }

                public void handleDone(Channel channel, final EJBReceiverContext context) {
                    channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                        public void handleClose(Channel closed, IOException exception) {
                            logger.debug((Object)("Closing channel" + closed), (Throwable)exception);
                            context.close();
                        }
                    });
                    logger.debug((Object)("Channel " + channel + " opened for context " + context + " Waiting for version handshake message from server"));
                    channel.receiveMessage((Channel.Receiver)versionReceiver);
                }
            }, (Object)context);
            successfulHandshake = false;
            try {
                successfulHandshake = versionHandshakeLatch.await(5L, TimeUnit.SECONDS);
                if (successfulHandshake) {
                    Channel compatibleChannel = versionReceiver.getCompatibleChannel();
                    ChannelAssociation channelAssociation = new ChannelAssociation(this, context, compatibleChannel, this.clientProtocolVersion, this.marshallerFactory, this.reconnectHandler);
                    Map<EJBReceiverContext, ChannelAssociation> map2 = this.channelAssociations;
                    synchronized (map2) {
                        this.channelAssociations.put(context, channelAssociation);
                    }
                    logger.info((Object)("Successful version handshake completed for receiver context " + context + " on channel " + compatibleChannel));
                    break block13;
                }
                logger.info((Object)("Version handshake not completed for receiver context " + context + " by receiver " + this + " . Closing the receiver context"));
                context.close();
            }
            catch (InterruptedException e) {
                context.close();
            }
        }
        if (successfulHandshake) {
            try {
                boolean initialReportAvailable = initialModuleAvailabilityLatch.await(5L, TimeUnit.SECONDS);
                if (!initialReportAvailable) {
                    logger.info((Object)("Initial module availability report for " + this + " wasn't received during the receiver context association"));
                }
            }
            catch (InterruptedException e) {
                logger.debug((Object)("Caught InterruptedException while waiting for initial module availability report for " + this), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInvocation(EJBClientInvocationContext clientInvocationContext, EJBReceiverInvocationContext ejbReceiverInvocationContext) throws Exception {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(ejbReceiverInvocationContext.getEjbReceiverContext());
        Channel channel = channelAssociation.getChannel();
        MethodInvocationMessageWriter messageWriter = new MethodInvocationMessageWriter(this.clientProtocolVersion, this.marshallerFactory);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        short invocationId = channelAssociation.getNextInvocationId();
        channelAssociation.receiveResponse(invocationId, ejbReceiverInvocationContext);
        try {
            messageWriter.writeMessage(dataOutputStream, invocationId, clientInvocationContext);
        }
        finally {
            dataOutputStream.close();
        }
    }

    @Override
    protected <T> StatefulEJBLocator<T> openSession(EJBReceiverContext receiverContext, Class<T> viewType, String appName, String moduleName, String distinctName, String beanName) throws IllegalArgumentException {
        SessionOpenResponseHandler.SessionOpenResponse sessionOpenResponse;
        EJBReceiverInvocationContext.ResultProducer resultProducer;
        DataOutputStream dataOutputStream;
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        Channel channel = channelAssociation.getChannel();
        SessionOpenRequestWriter sessionOpenRequestWriter = new SessionOpenRequestWriter(this.clientProtocolVersion);
        try {
            dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        short invocationId = channelAssociation.getNextInvocationId();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            sessionOpenRequestWriter.writeMessage(dataOutputStream, invocationId, appName, moduleName, distinctName, beanName);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        try {
            resultProducer = futureResultProducer.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            sessionOpenResponse = (SessionOpenResponseHandler.SessionOpenResponse)resultProducer.getResult();
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new StatefulEJBLocator<T>(viewType, appName, moduleName, beanName, distinctName, sessionOpenResponse.getSessionID(), sessionOpenResponse.getAffinity());
    }

    @Override
    public boolean exists(String appName, String moduleName, String distinctName, String beanName) {
        logger.warn((Object)"Not yet implemented RemotingConnectionEJBReceiver#verify");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendCommit(EJBReceiverContext receiverContext, TransactionID transactionID, boolean onePhase) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Channel channel = channelAssociation.getChannel();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
            TransactionMessageWriter transactionMessageWriter = new TransactionMessageWriter();
            try {
                transactionMessageWriter.writeTxCommit(dataOutputStream, invocationId, transactionID, onePhase);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending transaction commit message", ioe);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendRollback(EJBReceiverContext receiverContext, TransactionID transactionID) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Channel channel = channelAssociation.getChannel();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
            TransactionMessageWriter transactionMessageWriter = new TransactionMessageWriter();
            try {
                transactionMessageWriter.writeTxRollback(dataOutputStream, invocationId, transactionID);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending transaction rollback message", ioe);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int sendPrepare(EJBReceiverContext receiverContext, TransactionID transactionID) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Channel channel = channelAssociation.getChannel();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
            TransactionMessageWriter transactionMessageWriter = new TransactionMessageWriter();
            try {
                transactionMessageWriter.writeTxPrepare(dataOutputStream, invocationId, transactionID);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending transaction prepare message", ioe);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            Object result = resultProducer.getResult();
            if (result instanceof Integer) {
                return (Integer)result;
            }
            throw new RuntimeException("Unexpected result for transaction prepare: " + result);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendForget(EJBReceiverContext receiverContext, TransactionID transactionID) throws XAException {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Channel channel = channelAssociation.getChannel();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
            TransactionMessageWriter transactionMessageWriter = new TransactionMessageWriter();
            try {
                transactionMessageWriter.writeTxForget(dataOutputStream, invocationId, transactionID);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending transaction forget message", ioe);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeCompletion(EJBReceiverContext receiverContext, TransactionID transactionID) {
        ChannelAssociation channelAssociation = this.requireChannelAssociation(receiverContext);
        short invocationId = channelAssociation.getNextInvocationId();
        Channel channel = channelAssociation.getChannel();
        Future<EJBReceiverInvocationContext.ResultProducer> futureResultProducer = channelAssociation.enrollForResult(invocationId);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
            TransactionMessageWriter transactionMessageWriter = new TransactionMessageWriter();
            try {
                transactionMessageWriter.writeTxBeforeCompletion(dataOutputStream, invocationId, transactionID);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending transaction beforeCompletion message", ioe);
        }
        try {
            EJBReceiverInvocationContext.ResultProducer resultProducer = futureResultProducer.get();
            resultProducer.getResult();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modulesAvailable(EJBReceiverContext receiverContext, ModuleAvailabilityMessageHandler.EJBModuleIdentifier[] ejbModules) {
        CountDownLatch moduleAvailabilityReportLatch;
        logger.debug((Object)("Received module availability report for " + ejbModules.length + " modules"));
        for (ModuleAvailabilityMessageHandler.EJBModuleIdentifier moduleIdentifier : ejbModules) {
            logger.debug((Object)("Registering module " + moduleIdentifier + " availability for receiver context " + receiverContext));
            this.registerModule(moduleIdentifier.appName, moduleIdentifier.moduleName, moduleIdentifier.distinctName);
        }
        Map<EJBReceiverContext, CountDownLatch> map = this.moduleAvailabilityReportLatches;
        synchronized (map) {
            moduleAvailabilityReportLatch = this.moduleAvailabilityReportLatches.remove(receiverContext);
        }
        if (moduleAvailabilityReportLatch != null) {
            moduleAvailabilityReportLatch.countDown();
        }
    }

    void modulesUnavailable(EJBReceiverContext receiverContext, ModuleAvailabilityMessageHandler.EJBModuleIdentifier[] ejbModules) {
        logger.debug((Object)("Received module un-availability report for " + ejbModules.length + " modules"));
        for (ModuleAvailabilityMessageHandler.EJBModuleIdentifier moduleIdentifier : ejbModules) {
            logger.debug((Object)("Un-registering module " + moduleIdentifier + " from receiver context " + receiverContext));
            this.deregisterModule(moduleIdentifier.appName, moduleIdentifier.moduleName, moduleIdentifier.distinctName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelAssociation requireChannelAssociation(EJBReceiverContext ejbReceiverContext) {
        ChannelAssociation channelAssociation;
        Map<EJBReceiverContext, ChannelAssociation> map = this.channelAssociations;
        synchronized (map) {
            channelAssociation = this.channelAssociations.get(ejbReceiverContext);
        }
        if (channelAssociation == null) {
            throw new IllegalStateException("EJB communication channel jboss.ejb is not yet ready to receive invocations (perhaps version handshake hasn't been completed), for receiver context " + ejbReceiverContext);
        }
        return channelAssociation;
    }

    public String toString() {
        return this.cachedToString;
    }
}

