/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataOutput;
import java.io.IOException;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.remoting.AbstractMessageWriter;
import org.jboss.ejb.client.remoting.PackedInteger;

class TransactionMessageWriter
extends AbstractMessageWriter {
    private static final byte HEADER_TX_COMMIT_MESSAGE = 15;
    private static final byte HEADER_TX_ROLLBACK_MESSAGE = 16;
    private static final byte HEADER_TX_PREPARE_MESSAGE = 17;
    private static final byte HEADER_TX_FORGET_MESSAGE = 18;
    private static final byte HEADER_TX_BEFORE_COMPLETION_MESSAGE = 19;
    private static final byte HEADER_TX_RECOVER_MESSAGE = 25;

    TransactionMessageWriter() {
    }

    void writeTxCommit(DataOutput output, short invocationId, TransactionID transactionID, boolean onePhaseCommit) throws IOException {
        output.writeByte(15);
        output.writeShort(invocationId);
        byte[] transactionIDBytes = transactionID.getEncodedForm();
        PackedInteger.writePackedInteger(output, transactionIDBytes.length);
        output.write(transactionIDBytes);
        output.writeBoolean(onePhaseCommit);
    }

    void writeTxRollback(DataOutput output, short invocationId, TransactionID transactionID) throws IOException {
        output.writeByte(16);
        output.writeShort(invocationId);
        byte[] transactionIDBytes = transactionID.getEncodedForm();
        PackedInteger.writePackedInteger(output, transactionIDBytes.length);
        output.write(transactionIDBytes);
    }

    void writeTxPrepare(DataOutput output, short invocationId, TransactionID transactionID) throws IOException {
        output.writeByte(17);
        output.writeShort(invocationId);
        byte[] transactionIDBytes = transactionID.getEncodedForm();
        PackedInteger.writePackedInteger(output, transactionIDBytes.length);
        output.write(transactionIDBytes);
    }

    void writeTxForget(DataOutput output, short invocationId, TransactionID transactionID) throws IOException {
        output.writeByte(18);
        output.writeShort(invocationId);
        byte[] transactionIDBytes = transactionID.getEncodedForm();
        PackedInteger.writePackedInteger(output, transactionIDBytes.length);
        output.write(transactionIDBytes);
    }

    void writeTxBeforeCompletion(DataOutput output, short invocationId, TransactionID transactionID) throws IOException {
        output.writeByte(19);
        output.writeShort(invocationId);
        byte[] transactionIDBytes = transactionID.getEncodedForm();
        PackedInteger.writePackedInteger(output, transactionIDBytes.length);
        output.write(transactionIDBytes);
    }

    void writeTxRecover(DataOutput output, short invocationId, String txParentNodeName, int flags) throws IOException {
        output.writeByte(25);
        output.writeShort(invocationId);
        output.writeUTF(txParentNodeName);
        output.writeInt(flags);
    }
}

