/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.Logs;

public abstract class Attachable {
    private final Map<Object, Object> attachments;

    private Attachable(Map<Object, Object> attachments) {
        this.attachments = attachments;
    }

    Attachable() {
        this(new IdentityHashMap<Object, Object>());
    }

    Attachable(Attachable attachable) {
        this(attachable.attachments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAttachment(AttachmentKey<T> key) {
        Map<Object, Object> attachments;
        if (key == null) {
            return null;
        }
        Map<Object, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)attachments.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        Map<Object, Object> attachments;
        if (key == null) {
            throw Logs.MAIN.paramCannotBeNull("key");
        }
        if (value == null) {
            throw Logs.MAIN.paramCannotBeNull("value");
        }
        Map<Object, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)attachments.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T putAttachmentIfAbsent(AttachmentKey<T> key, T value) {
        Map<Object, Object> attachments;
        if (key == null) {
            throw Logs.MAIN.paramCannotBeNull("key");
        }
        if (value == null) {
            throw Logs.MAIN.paramCannotBeNull("value");
        }
        Map<Object, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)(attachments.containsKey(key) ? attachments.get(key) : attachments.put(key, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T replaceAttachment(AttachmentKey<T> key, T value) {
        Map<Object, Object> attachments;
        if (key == null) {
            return null;
        }
        if (value == null) {
            throw Logs.MAIN.paramCannotBeNull("value");
        }
        Map<Object, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)(attachments.containsKey(key) ? attachments.put(key, value) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean replaceAttachment(AttachmentKey<T> key, T oldValue, T newValue) {
        Map<Object, Object> attachments;
        if (key == null) {
            return false;
        }
        if (oldValue == null) {
            return false;
        }
        if (newValue == null) {
            throw Logs.MAIN.paramCannotBeNull("newValue");
        }
        Map<Object, Object> map = attachments = this.attachments;
        synchronized (map) {
            Object lhs = attachments.get(key);
            return attachments.containsKey(key) && oldValue.equals(lhs) && attachments.put(key, newValue) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeAttachment(AttachmentKey<T> key) {
        Map<Object, Object> attachments;
        if (key == null) {
            return null;
        }
        Map<Object, Object> map = attachments = this.attachments;
        synchronized (map) {
            return (T)attachments.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean removeAttachment(AttachmentKey<T> key, T value) {
        Map<Object, Object> attachments;
        if (key == null) {
            return false;
        }
        if (value == null) {
            return false;
        }
        Map<Object, Object> map = attachments = this.attachments;
        synchronized (map) {
            Object lhs = attachments.get(key);
            return attachments.containsKey(key) && value.equals(lhs) && attachments.remove(key) != null;
        }
    }

    void clearAttachments() {
        this.attachments.clear();
    }
}

