/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Closeable;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.logging.Logger;

public final class EJBReceiverContext
extends Attachable
implements Closeable {
    private static final Logger logger = Logger.getLogger(EJBReceiverContext.class);
    private final EJBReceiver receiver;
    private final EJBClientContext clientContext;
    private final String cachedToString;

    EJBReceiverContext(EJBReceiver receiver, EJBClientContext clientContext) {
        this.receiver = receiver;
        this.clientContext = clientContext;
        this.cachedToString = this.generateToString();
    }

    public EJBClientContext getClientContext() {
        return this.clientContext;
    }

    public EJBReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public void close() {
        this.clientContext.unregisterEJBReceiver(this.receiver);
    }

    public String toString() {
        return this.cachedToString;
    }

    private String generateToString() {
        return "EJBReceiverContext{clientContext=" + this.clientContext + ", receiver=" + this.receiver + '}';
    }
}

