/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.Logs;

public final class EJBClientInvocationContext
extends Attachable {
    private static final Logs log = Logs.MAIN;
    public static final String PRIVATE_ATTACHMENTS_KEY = "org.jboss.ejb.client.invocation.attachments";
    private final EJBInvocationHandler<?> invocationHandler;
    private final EJBClientContext ejbClientContext;
    private final Object invokedProxy;
    private final Method invokedMethod;
    private final Object[] parameters;
    private final Object lock = new Object();
    private EJBReceiverInvocationContext.ResultProducer resultProducer;
    private State state = State.WAITING;
    private AsyncState asyncState = AsyncState.SYNCHRONOUS;
    private Object cachedResult;
    private Map<String, Object> contextData;
    private EJBReceiverInvocationContext receiverInvocationContext;
    private Set<String> excludedNodes = new HashSet<String>();
    private final EJBClientInterceptor[] interceptorChain;
    private int interceptorChainIndex;
    private boolean resultDone;
    static final Object PROCEED_ASYNC = new Object();

    EJBClientInvocationContext(EJBInvocationHandler<?> invocationHandler, EJBClientContext ejbClientContext, Object invokedProxy, Method invokedMethod, Object[] parameters) {
        this.invocationHandler = invocationHandler;
        this.ejbClientContext = ejbClientContext;
        this.invokedProxy = invokedProxy;
        this.invokedMethod = invokedMethod;
        this.parameters = parameters;
        this.interceptorChain = ejbClientContext.getInterceptorChain();
    }

    public <T> T getProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.getAttachment(key);
    }

    public <T> T removeProxyAttachment(AttachmentKey<T> key) {
        return this.invocationHandler.removeAttachment(key);
    }

    EJBInvocationHandler<?> getInvocationHandler() {
        return this.invocationHandler;
    }

    public EJBClientContext getClientContext() {
        return this.ejbClientContext;
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new LinkedHashMap<String, Object>();
            return this.contextData;
        }
        return this.contextData;
    }

    public EJBLocator<?> getLocator() {
        return this.invocationHandler.getLocator();
    }

    public void sendRequest() throws Exception {
        int idx;
        EJBClientInterceptor[] chain = this.interceptorChain;
        if ((idx = this.interceptorChainIndex++) > chain.length) {
            throw Logs.MAIN.sendRequestCalledDuringWrongPhase();
        }
        if (chain.length == idx) {
            EJBReceiverInvocationContext context = this.receiverInvocationContext;
            if (context == null) {
                throw Logs.MAIN.noReceiverAssociatedWithInvocation();
            }
            context.getEjbReceiverContext().getReceiver().processInvocation(this, context);
        } else {
            chain[idx].handleInvocation(this);
        }
    }

    void retryRequest() throws Exception {
        int idx = this.interceptorChainIndex;
        EJBClientInterceptor[] chain = this.interceptorChain;
        if (idx <= chain.length) {
            throw Logs.MAIN.cannotRetryRequest();
        }
        this.interceptorChainIndex = 0;
        this.receiverInvocationContext = null;
        this.sendRequest();
    }

    Set<String> getExcludedNodes() {
        return Collections.unmodifiableSet(this.excludedNodes);
    }

    void markNodeAsExcluded(String nodeName) {
        if (nodeName == null || nodeName.trim().isEmpty()) {
            return;
        }
        this.excludedNodes.add(nodeName);
    }

    void setReceiverInvocationContext(EJBReceiverInvocationContext context) {
        this.receiverInvocationContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResult() throws Exception {
        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
        if (this.resultDone || resultProducer == null) {
            throw Logs.MAIN.getResultCalledDuringWrongPhase();
        }
        int idx = this.interceptorChainIndex++;
        EJBClientInterceptor[] chain = this.interceptorChain;
        if (idx == 0) {
            try {
                Object object = chain[idx].handleInvocationResult(this);
                return object;
            }
            finally {
                this.resultDone = true;
                Affinity weakAffinity = this.getAttachment(AttachmentKeys.WEAK_AFFINITY);
                if (weakAffinity != null) {
                    this.invocationHandler.setWeakAffinity(weakAffinity);
                }
            }
        }
        try {
            if (chain.length == idx) {
                Object object = resultProducer.getResult();
                return object;
            }
            Object object = chain[idx].handleInvocationResult(this);
            return object;
        }
        finally {
            this.resultDone = true;
        }
    }

    public void discardResult() throws IllegalStateException {
        EJBReceiverInvocationContext.ResultProducer resultProducer = this.resultProducer;
        if (resultProducer == null) {
            throw Logs.MAIN.discardResultCalledDuringWrongPhase();
        }
        resultProducer.discardResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resultReady(EJBReceiverInvocationContext.ResultProducer resultProducer) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    this.resultProducer = resultProducer;
                    this.interceptorChainIndex = 0;
                    this.state = State.READY;
                    this.lock.notifyAll();
                    return;
                }
            }
        }
        resultProducer.discardResult();
    }

    protected EJBReceiver getReceiver() {
        EJBReceiverInvocationContext context = this.receiverInvocationContext;
        if (context == null) {
            throw Logs.MAIN.noReceiverAssociatedWithInvocation();
        }
        return context.getEjbReceiverContext().getReceiver();
    }

    public Object getInvokedProxy() {
        return this.invokedProxy;
    }

    public Method getInvokedMethod() {
        return this.invokedMethod;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Class<?> getViewClass() {
        return this.invocationHandler.getLocator().getViewType();
    }

    Future<?> getFutureResponse() {
        return new FutureResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void proceedAsynchronously() {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncState == AsyncState.SYNCHRONOUS) {
                this.asyncState = AsyncState.ASYNCHRONOUS;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * Exception decompiling
     */
    Object awaitResponse() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDiscardResult() {
        EJBReceiverInvocationContext.ResultProducer resultProducer;
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            if (this.asyncState != AsyncState.ONE_WAY) {
                this.asyncState = AsyncState.ONE_WAY;
                this.lock.notifyAll();
            }
            if (this.state != State.DONE) {
                return;
            }
            this.state = State.DISCARDED;
            resultProducer = this.resultProducer;
            this.lock.notifyAll();
        }
        resultProducer.discardResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelled() {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    this.state = State.CANCELLED;
                    this.lock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed(Throwable exception) {
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    this.state = State.FAILED;
                    this.cachedResult = exception;
                    this.lock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        EJBReceiverInvocationContext.ResultProducer resultProducer;
        assert (!Thread.holdsLock(this.lock));
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case WAITING: 
                case CANCEL_REQ: {
                    return;
                }
                case READY: {
                    resultProducer = this.resultProducer;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        resultProducer.discardResult();
    }

    private class InvocationTimeoutResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final long timeout;

        InvocationTimeoutResultProducer(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public Object getResult() throws Exception {
            throw new TimeoutException("No invocation response received in " + this.timeout + " milliseconds");
        }

        @Override
        public void discardResult() {
        }
    }

    final class FutureResponse
    implements Future<Object> {
        FutureResponse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                if (EJBClientInvocationContext.this.state != State.WAITING) {
                    return false;
                }
                if (!mayInterruptIfRunning) {
                    return false;
                }
                EJBClientInvocationContext.this.state = State.CANCEL_REQ;
            }
            return EJBClientInvocationContext.this.getReceiver().cancelInvocation(EJBClientInvocationContext.this, EJBClientInvocationContext.this.receiverInvocationContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                return EJBClientInvocationContext.this.state == State.CANCELLED;
            }
        }

        @Override
        public boolean isDone() {
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                switch (EJBClientInvocationContext.this.state) {
                    case WAITING: {
                        return false;
                    }
                    case CANCEL_REQ: 
                    case READY: 
                    case FAILED: 
                    case CANCELLED: 
                    case DONE: 
                    case CONSUMING: 
                    case DISCARDED: {
                        return true;
                    }
                }
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get() throws InterruptedException, ExecutionException {
            Object result;
            EJBReceiverInvocationContext.ResultProducer resultProducer;
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                while (EJBClientInvocationContext.this.state == State.WAITING || EJBClientInvocationContext.this.state == State.CANCEL_REQ || EJBClientInvocationContext.this.state == State.CONSUMING) {
                    EJBClientInvocationContext.this.lock.wait();
                }
                switch (EJBClientInvocationContext.this.state) {
                    case READY: {
                        EJBClientInvocationContext.this.state = State.CONSUMING;
                        resultProducer = EJBClientInvocationContext.this.resultProducer;
                        break;
                    }
                    case FAILED: {
                        throw log.remoteInvFailed((Throwable)EJBClientInvocationContext.this.cachedResult);
                    }
                    case CANCELLED: {
                        throw log.requestCancelled();
                    }
                    case DONE: {
                        return EJBClientInvocationContext.this.cachedResult;
                    }
                    case DISCARDED: {
                        throw log.oneWayInvocation();
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            try {
                result = resultProducer.getResult();
            }
            catch (Exception e) {
                Object object2 = EJBClientInvocationContext.this.lock;
                synchronized (object2) {
                    assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                    EJBClientInvocationContext.this.state = State.FAILED;
                    EJBClientInvocationContext.this.cachedResult = e;
                    EJBClientInvocationContext.this.lock.notifyAll();
                }
                throw log.remoteInvFailed(e);
            }
            Object object3 = EJBClientInvocationContext.this.lock;
            synchronized (object3) {
                assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                EJBClientInvocationContext.this.state = State.DONE;
                EJBClientInvocationContext.this.cachedResult = result;
                EJBClientInvocationContext.this.lock.notifyAll();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object result;
            EJBReceiverInvocationContext.ResultProducer resultProducer;
            assert (!Thread.holdsLock(EJBClientInvocationContext.this.lock));
            Object object = EJBClientInvocationContext.this.lock;
            synchronized (object) {
                if (EJBClientInvocationContext.this.state == State.WAITING || EJBClientInvocationContext.this.state == State.CANCEL_REQ || EJBClientInvocationContext.this.state == State.CONSUMING) {
                    long now = System.nanoTime();
                    long end = Math.max(now, now + unit.toNanos(timeout));
                    do {
                        long remaining;
                        if ((remaining = end - now) <= 0L) {
                            throw log.timedOut();
                        }
                        long millis = (remaining + 999999L) / 1000000L;
                        EJBClientInvocationContext.this.lock.wait(millis);
                        now = System.nanoTime();
                    } while (EJBClientInvocationContext.this.state == State.WAITING || EJBClientInvocationContext.this.state == State.CANCEL_REQ || EJBClientInvocationContext.this.state == State.CONSUMING);
                }
                switch (EJBClientInvocationContext.this.state) {
                    case READY: {
                        EJBClientInvocationContext.this.state = State.CONSUMING;
                        resultProducer = EJBClientInvocationContext.this.resultProducer;
                        break;
                    }
                    case FAILED: {
                        throw log.remoteInvFailed((Throwable)EJBClientInvocationContext.this.cachedResult);
                    }
                    case CANCELLED: {
                        throw log.requestCancelled();
                    }
                    case DONE: {
                        return EJBClientInvocationContext.this.cachedResult;
                    }
                    case DISCARDED: {
                        throw log.oneWayInvocation();
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            try {
                result = resultProducer.getResult();
            }
            catch (Exception e) {
                Object object2 = EJBClientInvocationContext.this.lock;
                synchronized (object2) {
                    assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                    EJBClientInvocationContext.this.state = State.FAILED;
                    EJBClientInvocationContext.this.cachedResult = e;
                    EJBClientInvocationContext.this.lock.notifyAll();
                }
                throw log.remoteInvFailed(e);
            }
            Object object3 = EJBClientInvocationContext.this.lock;
            synchronized (object3) {
                assert (EJBClientInvocationContext.this.state == State.CONSUMING);
                EJBClientInvocationContext.this.state = State.DONE;
                EJBClientInvocationContext.this.cachedResult = result;
                EJBClientInvocationContext.this.lock.notifyAll();
            }
            return result;
        }
    }

    static enum State {
        WAITING,
        CANCEL_REQ,
        CANCELLED,
        READY,
        CONSUMING,
        FAILED,
        DONE,
        DISCARDED;

    }

    static enum AsyncState {
        SYNCHRONOUS,
        ASYNCHRONOUS,
        ONE_WAY;

    }
}

