/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.logging.Logger;

class NoSuchEJBExceptionResponseHandler
extends ProtocolMessageHandler {
    private static final Logger logger = Logger.getLogger(NoSuchEJBExceptionResponseHandler.class);
    private final ChannelAssociation channelAssociation;

    NoSuchEJBExceptionResponseHandler(ChannelAssociation channelAssociation) {
        this.channelAssociation = channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(InputStream inputStream) throws IOException {
        NoSuchEJBException noSuchEJBException;
        short invocationId;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            invocationId = dataInputStream.readShort();
            String failureMessage = dataInputStream.readUTF();
            noSuchEJBException = new NoSuchEJBException(failureMessage);
        }
        finally {
            dataInputStream.close();
        }
        EJBReceiverInvocationContext receiverInvocationContext = this.channelAssociation.getEJBReceiverInvocationContext(invocationId);
        if (receiverInvocationContext == null) {
            logger.info((Object)"Cannot retry invocation which failed with exception:", (Throwable)noSuchEJBException);
            this.channelAssociation.resultReady(invocationId, new ResultProducer((Exception)noSuchEJBException));
            return;
        }
        try {
            logger.info((Object)("Retrying invocation which failed on node " + receiverInvocationContext.getNodeName() + " with exception:"), (Throwable)noSuchEJBException);
            this.channelAssociation.cleanupStaleResponse(invocationId);
            receiverInvocationContext.retryInvocation(true);
        }
        catch (Exception e) {
            this.channelAssociation.resultReady(invocationId, new ResultProducer(e));
            return;
        }
    }

    private class ResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final Exception exception;

        ResultProducer(Exception exception) {
            this.exception = exception;
        }

        @Override
        public Object getResult() throws Exception {
            NoSuchEJBExceptionResponseHandler.this.glueStackTraces(this.exception, Thread.currentThread().getStackTrace(), 1, "asynchronous invocation");
            throw this.exception;
        }

        @Override
        public void discardResult() {
        }
    }
}

