/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.protocol.remote.AbstractWritingExternalizer;
import org.jboss.ejb.protocol.remote.ByteExternalizer;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

final class ProtocolV3ObjectTable
implements ObjectTable {
    static final ProtocolV3ObjectTable INSTANCE = new ProtocolV3ObjectTable();
    private static final Map<Object, AbstractWritingExternalizer> objectWriters;
    private static final Map<Class<?>, AbstractWritingExternalizer> classWriters;
    private static final AbstractWritingExternalizer[] extById;

    ProtocolV3ObjectTable() {
    }

    public ObjectTable.Writer getObjectWriter(Object object) throws IOException {
        ObjectTable.Writer writer = objectWriters.get(object);
        if (writer == null) {
            writer = classWriters.get(object.getClass());
        }
        return writer;
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int idx = unmarshaller.readUnsignedByte();
        if (idx >= extById.length) {
            throw new InvalidObjectException("ObjectTable " + this.getClass().getName() + " cannot find an object for object index " + idx);
        }
        return extById[idx].createExternal(Object.class, (ObjectInput)unmarshaller, null);
    }

    static {
        Object[] simpleObjects = new Object[]{"jboss.transaction.id", Affinity.NONE, Affinity.LOCAL, "jboss.ejb.weak.affinity", "org.jboss.ejb.client.invocation.attachments", AttachmentKeys.TRANSACTION_ID_KEY, AttachmentKeys.WEAK_AFFINITY, AttachmentKeys.COMPRESS_RESPONSE, AttachmentKeys.RESPONSE_COMPRESSION_LEVEL, AttachmentKeys.TRANSACTION_KEY, AttachmentKeys.HINTS_DISABLED, AttachmentKeys.VIEW_CLASS_DATA_COMPRESSION_HINT_ATTACHMENT_KEY, AttachmentKeys.VIEW_METHOD_DATA_COMPRESSION_HINT_ATTACHMENT_KEY, Throwable.class.getName(), Exception.class.getName(), RuntimeException.class.getName(), "detailMessage", "cause", "stackTrace", "value", "suppressedExceptions", "ejbCreate", "ejbRemove", "ejbHome", "remove", "ejbActivate", "ejbPassivate", "ejbLoad", "ejbStore"};
        AbstractWritingExternalizer[] extByIdTmp = new AbstractWritingExternalizer[simpleObjects.length];
        HashMap<Object, AbstractWritingExternalizer> objMap = new HashMap<Object, AbstractWritingExternalizer>();
        int simpleObjectsLength = simpleObjects.length;
        for (int i = 0; i < simpleObjectsLength; ++i) {
            ByteExternalizer ext = new ByteExternalizer(simpleObjects[i], i);
            extByIdTmp[i] = ext;
            objMap.put(ext.getObject(), ext);
        }
        extById = extByIdTmp;
        objectWriters = objMap;
        classWriters = Collections.emptyMap();
    }
}

