/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.net.URI;
import javax.ejb.CreateException;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.xnio.FinishedIoFuture;
import org.xnio.IoFuture;

class RemoteEJBReceiver
extends EJBReceiver {
    static final IoFuture.HandlingNotifier<Connection, EJBReceiverInvocationContext> NOTIFIER = new IoFuture.HandlingNotifier<Connection, EJBReceiverInvocationContext>(){

        public void handleDone(Connection connection, EJBReceiverInvocationContext attachment) {
            EJBClientChannel ejbClientChannel;
            try {
                ejbClientChannel = EJBClientChannel.from(connection);
            }
            catch (IOException e) {
                attachment.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(new RequestSendFailedException(e)));
                return;
            }
            ejbClientChannel.processInvocation(attachment);
        }

        public void handleCancelled(EJBReceiverInvocationContext attachment) {
            attachment.requestCancelled();
        }

        public void handleFailed(IOException exception, EJBReceiverInvocationContext attachment) {
            attachment.resultReady(new EJBReceiverInvocationContext.ResultProducer.Failed(new RequestSendFailedException(exception)));
        }
    };

    RemoteEJBReceiver() {
    }

    @Override
    protected void processInvocation(EJBReceiverInvocationContext receiverContext) throws Exception {
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator<?> locator = clientInvocationContext.getLocator();
        NamingProvider namingProvider = receiverContext.getNamingProvider();
        IoFuture<Connection> futureConnection = this.getConnection(locator, namingProvider);
        futureConnection.addNotifier(NOTIFIER, (Object)receiverContext);
    }

    @Override
    protected boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        NamingProvider namingProvider = receiverContext.getNamingProvider();
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator<?> locator = clientInvocationContext.getLocator();
        try {
            IoFuture<Connection> futureConnection = this.getConnection(locator, namingProvider);
            Connection connection = (Connection)futureConnection.get();
            EJBClientChannel channel = EJBClientChannel.from(connection);
            return channel.cancelInvocation(receiverContext, cancelIfRunning);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected <T> StatefulEJBLocator<T> createSession(StatelessEJBLocator<T> statelessLocator) throws Exception {
        try {
            IoFuture<Connection> futureConnection = this.getConnection(statelessLocator, null);
            EJBClientChannel ejbClientChannel = EJBClientChannel.from((Connection)futureConnection.getInterruptibly());
            return ejbClientChannel.openSession(statelessLocator);
        }
        catch (IOException e) {
            CreateException createException = new CreateException("Failed to create stateful EJB: " + e.getMessage());
            createException.initCause((Throwable)e);
            throw createException;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CreateException("Stateful EJB creation interrupted");
        }
    }

    private <T> IoFuture<Connection> getConnection(EJBLocator<T> locator, NamingProvider namingProvider) throws Exception {
        URI target;
        Connection namingConnection = namingProvider instanceof RemoteNamingProvider ? ((RemoteNamingProvider)namingProvider).getPeerIdentity().getConnection() : null;
        Affinity affinity = locator.getAffinity();
        if (affinity instanceof URIAffinity) {
            target = ((URIAffinity)affinity).getUri();
            if (namingConnection != null && target.equals(namingConnection.getPeerURI())) {
                return new FinishedIoFuture((Object)namingConnection);
            }
        } else {
            throw new IllegalArgumentException("Invalid EJB affinity");
        }
        return Endpoint.getCurrent().getConnection(target);
    }
}

