/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.net.Inet6Address;
import java.net.SocketAddress;
import java.security.AccessController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.ejb.protocol.remote.NoFlushByteOutput;
import org.jboss.ejb.protocol.remote.PackedInteger;
import org.jboss.ejb.protocol.remote.ProtocolV1ClassTable;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectTable;
import org.jboss.ejb.protocol.remote.ProtocolV3ObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV3ObjectTable;
import org.jboss.ejb.protocol.remote.WrapperMessageOutputStream;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.CancelHandle;
import org.jboss.ejb.server.ClusterTopologyListener;
import org.jboss.ejb.server.InvocationRequest;
import org.jboss.ejb.server.ListenerHandle;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.ejb.server.Request;
import org.jboss.ejb.server.SessionOpenRequest;
import org.jboss.marshalling.AbstractClassResolver;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3.util.MessageTracker;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionServer;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;
import org.xnio.IoUtils;

final class EJBServerChannel {
    private static final char METHOD_PARAM_TYPE_SEPARATOR = ',';
    private final RemotingTransactionServer transactionServer;
    private final Channel channel;
    private final int version;
    private final MessageTracker messageTracker;
    private final MarshallerFactory marshallerFactory;
    private final MarshallingConfiguration configuration;
    private final IntIndexHashMap<InProgress> invocations = new IntIndexHashMap(InProgress::getInvId);

    EJBServerChannel(RemotingTransactionServer transactionServer, Channel channel, int version, MessageTracker messageTracker) {
        this.transactionServer = transactionServer;
        this.channel = channel;
        this.version = version;
        this.messageTracker = messageTracker;
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        if (version < 3) {
            configuration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
            configuration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
            configuration.setObjectResolver((ObjectResolver)new ProtocolV1ObjectResolver(channel.getConnection(), true));
            configuration.setVersion(2);
        } else {
            configuration.setObjectTable((ObjectTable)ProtocolV3ObjectTable.INSTANCE);
            configuration.setObjectResolver((ObjectResolver)new ProtocolV3ObjectResolver(channel.getConnection(), true));
            configuration.setVersion(4);
        }
        this.marshallerFactory = new RiverMarshallerFactory();
        this.configuration = configuration;
    }

    Channel.Receiver getReceiver(Association association, ListenerHandle handle1, ListenerHandle handle2) {
        return new ReceiverImpl(association, handle1, handle2);
    }

    ClusterTopologyListener createTopologyListener() {
        return new ClusterTopologyWriter();
    }

    ModuleAvailabilityListener createModuleListener() {
        return new ModuleAvailabilityWriter();
    }

    ExceptionSupplier<ImportResult<?>, SystemException> readTransaction(DataInput input) throws IOException {
        int type = input.readUnsignedByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            int id = input.readInt();
            int timeout = PackedInteger.readPackedInteger(input);
            return () -> new ImportResult((Transaction)this.transactionServer.getOrBeginTransaction(id, timeout), SubordinateTransactionControl.EMPTY, false);
        }
        if (type == 2) {
            int fmt = PackedInteger.readPackedInteger(input);
            byte[] gtid = new byte[input.readUnsignedByte()];
            input.readFully(gtid);
            byte[] bq = new byte[input.readUnsignedByte()];
            input.readFully(bq);
            int timeout = PackedInteger.readPackedInteger(input);
            return () -> {
                try {
                    return this.transactionServer.getTransactionService().getTransactionContext().findOrImportTransaction((Xid)new SimpleXid(fmt, gtid, bq), timeout);
                }
                catch (XAException e) {
                    throw new SystemException(e.getMessage());
                }
            };
        }
        throw Logs.REMOTING.invalidTransactionType(type);
    }

    private void writeFailedResponse(int invId, Exception e) {
        try (MessageOutputStream os = this.messageTracker.openMessageUninterruptibly();){
            os.writeByte(6);
            os.writeShort(invId);
            Marshaller marshaller = this.marshallerFactory.createMarshaller(this.configuration);
            marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)os)));
            marshaller.writeObject((Object)new RequestSendFailedException(e));
            marshaller.writeByte(0);
            marshaller.finish();
        }
        catch (IOException e2) {
            Logs.REMOTING.trace("EJB response write failed", e2);
        }
    }

    final class ModuleAvailabilityWriter
    implements ModuleAvailabilityListener {
        ModuleAvailabilityWriter() {
        }

        @Override
        public void moduleAvailable(List<ModuleAvailabilityListener.ModuleIdentifier> modules) {
            this.doWrite(true, modules);
        }

        @Override
        public void moduleUnavailable(List<ModuleAvailabilityListener.ModuleIdentifier> modules) {
            this.doWrite(false, modules);
        }

        private void doWrite(boolean available, List<ModuleAvailabilityListener.ModuleIdentifier> modules) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(available ? 8 : 9);
                PackedInteger.writePackedInteger((DataOutput)os, modules.size());
                for (ModuleAvailabilityListener.ModuleIdentifier module : modules) {
                    String appName = module.getAppName();
                    os.writeUTF(appName == null ? "" : appName);
                    String moduleName = module.getModuleName();
                    os.writeUTF(moduleName == null ? "" : moduleName);
                    String distinctName = module.getDistinctName();
                    os.writeUTF(distinctName == null ? "" : distinctName);
                }
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB availability message write failed", e);
            }
        }
    }

    final class ClusterTopologyWriter
    implements ClusterTopologyListener {
        ClusterTopologyWriter() {
        }

        @Override
        public void clusterTopology(List<ClusterTopologyListener.ClusterInfo> clusterInfoList) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(21);
                PackedInteger.writePackedInteger((DataOutput)os, clusterInfoList.size());
                for (ClusterTopologyListener.ClusterInfo clusterInfo : clusterInfoList) {
                    os.writeUTF(clusterInfo.getClusterName());
                    List<ClusterTopologyListener.NodeInfo> nodeInfoList = clusterInfo.getNodeInfoList();
                    PackedInteger.writePackedInteger((DataOutput)os, nodeInfoList.size());
                    for (ClusterTopologyListener.NodeInfo nodeInfo : nodeInfoList) {
                        os.writeUTF(nodeInfo.getNodeName());
                        List<ClusterTopologyListener.MappingInfo> mappingInfoList = nodeInfo.getMappingInfoList();
                        PackedInteger.writePackedInteger((DataOutput)os, mappingInfoList.size());
                        for (ClusterTopologyListener.MappingInfo mappingInfo : mappingInfoList) {
                            boolean is6 = mappingInfo.getSourceAddress() instanceof Inet6Address;
                            if (is6) {
                                PackedInteger.writePackedInteger((DataOutput)os, mappingInfo.getNetmaskBits() << 1);
                            } else {
                                PackedInteger.writePackedInteger((DataOutput)os, mappingInfo.getNetmaskBits() << 1 | 1);
                            }
                            os.write(mappingInfo.getSourceAddress().getAddress());
                            os.writeUTF(mappingInfo.getDestinationAddress());
                            os.writeShort(mappingInfo.getDestinationPort());
                        }
                    }
                }
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB cluster message write failed", e);
            }
        }

        @Override
        public void clusterRemoval(List<String> clusterNames) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(22);
                PackedInteger.writePackedInteger((DataOutput)os, clusterNames.size());
                for (String clusterName : clusterNames) {
                    os.writeUTF(clusterName);
                }
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB cluster message write failed", e);
            }
        }

        @Override
        public void clusterNewNodesAdded(ClusterTopologyListener.ClusterInfo clusterInfo) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(23);
                PackedInteger.writePackedInteger((DataOutput)os, 1);
                os.writeUTF(clusterInfo.getClusterName());
                List<ClusterTopologyListener.NodeInfo> nodeInfoList = clusterInfo.getNodeInfoList();
                PackedInteger.writePackedInteger((DataOutput)os, nodeInfoList.size());
                for (ClusterTopologyListener.NodeInfo nodeInfo : nodeInfoList) {
                    os.writeUTF(nodeInfo.getNodeName());
                    List<ClusterTopologyListener.MappingInfo> mappingInfoList = nodeInfo.getMappingInfoList();
                    PackedInteger.writePackedInteger((DataOutput)os, mappingInfoList.size());
                    for (ClusterTopologyListener.MappingInfo mappingInfo : mappingInfoList) {
                        boolean is6 = mappingInfo.getSourceAddress() instanceof Inet6Address;
                        if (is6) {
                            PackedInteger.writePackedInteger((DataOutput)os, mappingInfo.getNetmaskBits() << 1);
                        } else {
                            PackedInteger.writePackedInteger((DataOutput)os, mappingInfo.getNetmaskBits() << 1 | 1);
                        }
                        os.write(mappingInfo.getSourceAddress().getAddress());
                        os.writeUTF(mappingInfo.getDestinationAddress());
                        os.writeShort(mappingInfo.getDestinationPort());
                    }
                }
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB cluster message write failed", e);
            }
        }

        @Override
        public void clusterNodesRemoved(List<ClusterTopologyListener.ClusterRemovalInfo> clusterRemovalInfoList) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(24);
                PackedInteger.writePackedInteger((DataOutput)os, clusterRemovalInfoList.size());
                for (ClusterTopologyListener.ClusterRemovalInfo removalInfo : clusterRemovalInfoList) {
                    os.writeUTF(removalInfo.getClusterName());
                    List<String> nodeNamesList = removalInfo.getNodeNames();
                    PackedInteger.writePackedInteger((DataOutput)os, nodeNamesList.size());
                    for (String name : nodeNamesList) {
                        os.writeUTF(name);
                    }
                }
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB cluster message write failed", e);
            }
        }
    }

    static final class ServerClassResolver
    extends AbstractClassResolver {
        private ClassLoader classLoader;

        ServerClassResolver() {
            super(true);
        }

        public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
            int length = interfaces.length;
            Class[] classes = new Class[length];
            for (int i = 0; i < length; ++i) {
                classes[i] = this.loadClass(interfaces[i]);
            }
            ClassLoader classLoader = length == 1 ? AccessController.doPrivileged(classes[0]::getClassLoader) : this.getClassLoader();
            return Proxy.getProxyClass(classLoader, classes);
        }

        protected ClassLoader getClassLoader() {
            ClassLoader classLoader = this.classLoader;
            return classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
        }

        void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : classLoader;
        }
    }

    static final class InProgress {
        private final RemotingInvocationRequest incomingInvocation;
        private final CancelHandle cancelHandle;

        InProgress(RemotingInvocationRequest incomingInvocation, CancelHandle cancelHandle) {
            this.incomingInvocation = incomingInvocation;
            this.cancelHandle = cancelHandle;
        }

        int getInvId() {
            return this.incomingInvocation.invId;
        }

        CancelHandle getCancelHandle() {
            return this.cancelHandle;
        }
    }

    final class RemotingInvocationRequest
    extends RemotingRequest
    implements InvocationRequest {
        final Connection connection;
        final Association association;
        final EJBIdentifier identifier;
        final EJBMethodLocator methodLocator;
        final ServerClassResolver classResolver;
        final Unmarshaller remaining;
        int txnCmd;

        RemotingInvocationRequest(int invId, Connection connection, Association association, EJBIdentifier identifier, EJBMethodLocator methodLocator, ServerClassResolver classResolver, Unmarshaller remaining, SecurityIdentity identity) {
            super(invId, identity);
            this.txnCmd = 0;
            this.connection = connection;
            this.association = association;
            this.identifier = identifier;
            this.methodLocator = methodLocator;
            this.classResolver = classResolver;
            this.remaining = remaining;
        }

        @Override
        public InvocationRequest.Resolved getRequestContent(ClassLoader classLoader) throws IOException, ClassNotFoundException {
            this.classResolver.setClassLoader(classLoader);
            int responseCompressLevel = 0;
            try (Unmarshaller unmarshaller = this.remaining;){
                EJBLocator locator;
                Affinity weakAffinity = Affinity.NONE;
                ExceptionSupplier transactionSupplier = null;
                if (EJBServerChannel.this.version >= 3) {
                    weakAffinity = (Affinity)unmarshaller.readObject(Affinity.class);
                    if (weakAffinity == null) {
                        weakAffinity = Affinity.NONE;
                    }
                    int flags = unmarshaller.readUnsignedByte();
                    responseCompressLevel = flags & 0xF;
                    transactionSupplier = EJBServerChannel.this.readTransaction((DataInput)unmarshaller);
                    locator = (EJBLocator)unmarshaller.readObject(EJBLocator.class);
                    if (this.identifier != locator.getIdentifier()) {
                        throw Logs.REMOTING.mismatchedMethodLocation();
                    }
                } else {
                    assert (EJBServerChannel.this.version <= 2);
                    locator = (EJBLocator)unmarshaller.readObject(EJBLocator.class);
                    if (this.identifier.getAppName() != locator.getAppName() || this.identifier.getModuleName() != locator.getModuleName() || this.identifier.getBeanName() != locator.getBeanName() || this.identifier.getDistinctName() != locator.getDistinctName()) {
                        throw Logs.REMOTING.mismatchedMethodLocation();
                    }
                }
                final Object[] parameters = new Object[this.methodLocator.getParameterCount()];
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i] = unmarshaller.readObject();
                }
                int attachmentCount = PackedInteger.readPackedInteger((DataInput)unmarshaller);
                final HashMap<String, Object> attachments = new HashMap<String, Object>(attachmentCount);
                for (int i = 0; i < attachmentCount; ++i) {
                    String attName = (String)unmarshaller.readObject(String.class);
                    if (attName.equals("org.jboss.ejb.client.invocation.attachments")) {
                        if (EJBServerChannel.this.version <= 2) {
                            Map map = (Map)unmarshaller.readObject();
                            Object transactionIdObject = map.get(AttachmentKeys.TRANSACTION_ID_KEY);
                            if (transactionIdObject != null) {
                                TransactionID transactionId = (TransactionID)transactionIdObject;
                                if (transactionId instanceof UserTransactionID) {
                                    transactionSupplier = () -> new ImportResult((Transaction)EJBServerChannel.this.transactionServer.getOrBeginTransaction(((UserTransactionID)transactionId).getId(), 0), SubordinateTransactionControl.EMPTY, false);
                                } else if (transactionId instanceof XidTransactionID) {
                                    transactionSupplier = () -> {
                                        try {
                                            return EJBServerChannel.this.transactionServer.getTransactionService().getTransactionContext().findOrImportTransaction(((XidTransactionID)transactionId).getXid(), 0);
                                        }
                                        catch (XAException e) {
                                            throw new SystemException(e.getMessage());
                                        }
                                    };
                                } else {
                                    throw Assert.impossibleSwitchCase((Object)transactionId);
                                }
                            }
                            weakAffinity = map.getOrDefault(AttachmentKeys.WEAK_AFFINITY, weakAffinity);
                            continue;
                        }
                        unmarshaller.readObject();
                        continue;
                    }
                    attachments.put(attName, unmarshaller.readObject());
                }
                attachments.put("jboss.source-address", EJBServerChannel.this.channel.getConnection().getPeerAddress());
                final ExceptionSupplier finalTransactionSupplier = transactionSupplier;
                final int finalResponseCompressLevel = responseCompressLevel == 15 ? -1 : Math.min(responseCompressLevel, 9);
                InvocationRequest.Resolved resolved = new InvocationRequest.Resolved(){

                    @Override
                    @NotNull
                    public Map<String, Object> getAttachments() {
                        return attachments;
                    }

                    @Override
                    @NotNull
                    public Object[] getParameters() {
                        return parameters;
                    }

                    @Override
                    @NotNull
                    public EJBLocator<?> getEJBLocator() {
                        return locator;
                    }

                    @Override
                    public boolean hasTransaction() {
                        return finalTransactionSupplier != null;
                    }

                    @Override
                    public Transaction getTransaction() throws SystemException, IllegalStateException {
                        if (finalTransactionSupplier == null) {
                            return null;
                        }
                        if (RemotingInvocationRequest.this.txnCmd != 0) {
                            throw new IllegalStateException();
                        }
                        ImportResult importResult = (ImportResult)finalTransactionSupplier.get();
                        RemotingInvocationRequest.this.txnCmd = importResult.isNew() ? 1 : 2;
                        return importResult.getTransaction();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void writeInvocationResult(Object result) {
                        try (MessageOutputStream underlying = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                            MessageOutputStream os;
                            if (finalResponseCompressLevel != 0) {
                                underlying.writeByte(27);
                                os = new WrapperMessageOutputStream(underlying, new DeflaterOutputStream((OutputStream)underlying, new Deflater(finalResponseCompressLevel)));
                            } else {
                                os = underlying;
                            }
                            os.writeByte(5);
                            os.writeShort(RemotingInvocationRequest.this.invId);
                            if (EJBServerChannel.this.version >= 3) {
                                os.writeByte(RemotingInvocationRequest.this.txnCmd);
                                if (RemotingInvocationRequest.this.sessionId == null) {
                                    os.writeBoolean(false);
                                } else {
                                    os.writeBoolean(true);
                                    byte[] bytes = RemotingInvocationRequest.this.sessionId.getEncodedForm();
                                    PackedInteger.writePackedInteger((DataOutput)os, bytes.length);
                                    os.write(bytes);
                                }
                            }
                            Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                            marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)os)));
                            marshaller.writeObject(result);
                            attachments.remove("jboss.source-address");
                            int count = attachments.size();
                            if (count > 255) {
                                marshaller.writeByte(255);
                            } else {
                                marshaller.writeByte(count);
                            }
                            int i = 0;
                            for (Map.Entry entry : attachments.entrySet()) {
                                marshaller.writeObject(entry.getKey());
                                marshaller.writeObject(entry.getValue());
                                if (i++ != 255) continue;
                                break;
                            }
                            marshaller.finish();
                            os.close();
                        }
                        catch (IOException e) {
                            Logs.REMOTING.trace("EJB response write failed", e);
                        }
                        finally {
                            EJBServerChannel.this.invocations.removeKey(RemotingInvocationRequest.this.invId);
                        }
                    }
                };
                return resolved;
            }
        }

        @Override
        public void writeProceedAsync() {
            if (EJBServerChannel.this.version >= 3) {
                return;
            }
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(14);
                os.writeShort(this.invId);
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB async response write failed", e);
            }
        }

        @Override
        @NotNull
        public EJBIdentifier getEJBIdentifier() {
            return this.identifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeNoSuchMethod() {
            String message = Logs.REMOTING.remoteMessageNoSuchMethod(this.methodLocator, this.identifier);
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(11);
                os.writeShort(this.invId);
                os.writeUTF(message);
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB response write failed", e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeSessionNotActive() {
            String message = Logs.REMOTING.remoteMessageSessionNotActive(this.methodLocator, this.identifier);
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(11);
                os.writeShort(this.invId);
                os.writeUTF(message);
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB response write failed", e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        @Override
        int getEnlistmentStatus() {
            return this.txnCmd;
        }

        @Override
        public void writeException(@NotNull Exception exception) {
            Assert.checkNotNullParam((String)"exception", (Object)exception);
            this.writeFailure(exception);
        }

        @Override
        public EJBMethodLocator getMethodLocator() {
            return this.methodLocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeCancellation() {
            if (EJBServerChannel.this.version >= 3) {
                try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                    os.writeByte(7);
                    os.writeShort(this.invId);
                }
                catch (IOException e) {
                    Logs.REMOTING.trace("EJB response write failed", e);
                }
                finally {
                    EJBServerChannel.this.invocations.removeKey(this.invId);
                }
            } else {
                this.writeFailure(Logs.REMOTING.requestCancelled());
            }
        }
    }

    final class RemotingSessionOpenRequest
    extends RemotingRequest
    implements SessionOpenRequest {
        private final EJBIdentifier identifier;
        final ExceptionSupplier<ImportResult<?>, SystemException> transactionSupplier;
        int txnCmd;

        RemotingSessionOpenRequest(int invId, EJBIdentifier identifier, ExceptionSupplier<ImportResult<?>, SystemException> transactionSupplier, SecurityIdentity identity) {
            super(invId, identity);
            this.txnCmd = 0;
            this.transactionSupplier = transactionSupplier;
            this.identifier = identifier;
        }

        @Override
        @NotNull
        public EJBIdentifier getEJBIdentifier() {
            return this.identifier;
        }

        @Override
        public boolean hasTransaction() {
            return this.transactionSupplier != null;
        }

        @Override
        public Transaction getTransaction() throws SystemException, IllegalStateException {
            ExceptionSupplier<ImportResult<?>, SystemException> transactionSupplier = this.transactionSupplier;
            if (transactionSupplier == null) {
                return null;
            }
            if (this.txnCmd != 0) {
                throw new IllegalStateException();
            }
            ImportResult importResult = (ImportResult)transactionSupplier.get();
            this.txnCmd = importResult.isNew() ? 1 : 2;
            return importResult.getTransaction();
        }

        @Override
        int getEnlistmentStatus() {
            return this.txnCmd;
        }

        @Override
        public void writeException(@NotNull Exception exception) {
            Assert.checkNotNullParam((String)"exception", (Object)exception);
            this.writeFailure(exception);
        }

        @Override
        public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
            super.convertToStateful(sessionId);
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(2);
                os.writeShort(this.invId);
                byte[] encodedForm = sessionId.getEncodedForm();
                PackedInteger.writePackedInteger((DataOutput)os, encodedForm.length);
                os.write(encodedForm);
                if (1 <= EJBServerChannel.this.version && EJBServerChannel.this.version <= 2) {
                    Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                    marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)os)));
                    marshaller.writeObject((Object)new NodeAffinity(EJBServerChannel.this.channel.getConnection().getEndpoint().getName()));
                    marshaller.finish();
                } else {
                    assert (EJBServerChannel.this.version >= 3);
                    os.writeByte(this.txnCmd);
                }
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB session open response write failed", e);
            }
        }
    }

    abstract class RemotingRequest
    implements Request {
        final int invId;
        SessionID sessionId;
        final SecurityIdentity identity;

        RemotingRequest(int invId, SecurityIdentity identity) {
            this.invId = invId;
            this.identity = identity;
        }

        @Override
        public Executor getRequestExecutor() {
            return EJBServerChannel.this.channel.getConnection().getEndpoint().getXnioWorker();
        }

        @Override
        public SocketAddress getPeerAddress() {
            return EJBServerChannel.this.channel.getConnection().getPeerAddress();
        }

        @Override
        public SocketAddress getLocalAddress() {
            return EJBServerChannel.this.channel.getConnection().getLocalAddress();
        }

        @Override
        public String getProtocol() {
            return EJBServerChannel.this.channel.getConnection().getProtocol();
        }

        @Override
        public boolean isBlockingCaller() {
            return false;
        }

        @Override
        public SecurityIdentity getSecurityIdentity() {
            return this.identity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeNoSuchEJB() {
            String message = Logs.REMOTING.remoteMessageNoSuchEJB(this.getEJBIdentifier());
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(10);
                os.writeShort(this.invId);
                os.writeUTF(message);
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB response write failed", e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeWrongViewType() {
            String message = Logs.REMOTING.remoteMessageBadViewType(this.getEJBIdentifier());
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                if (EJBServerChannel.this.version >= 3) {
                    os.writeByte(28);
                    os.writeShort(this.invId);
                    os.writeUTF(message);
                } else {
                    os.writeByte(6);
                    os.writeShort(this.invId);
                    Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                    marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)os)));
                    marshaller.writeObject((Object)Logs.REMOTING.invalidViewTypeForInvocation(message));
                    marshaller.writeByte(0);
                    marshaller.finish();
                }
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB response write failed", e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeCancelResponse() {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(7);
                os.writeShort(this.invId);
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB response write failed", e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeNotStateful() {
            String message = Logs.REMOTING.remoteMessageEJBNotStateful(this.getEJBIdentifier());
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(13);
                os.writeShort(this.invId);
                os.writeUTF(message);
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB response write failed", e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        @Override
        public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
            Assert.checkNotNullParam((String)"sessionId", (Object)sessionId);
            SessionID ourSessionId = this.sessionId;
            if (ourSessionId != null) {
                if (!sessionId.equals((Object)ourSessionId)) {
                    throw new IllegalStateException();
                }
            } else {
                this.sessionId = sessionId;
            }
        }

        @Override
        public <C> C getProviderInterface(Class<C> providerInterfaceType) {
            Connection connection = EJBServerChannel.this.channel.getConnection();
            return providerInterfaceType.isInstance(connection) ? (C)providerInterfaceType.cast(connection) : null;
        }

        abstract int getEnlistmentStatus();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeFailure(Exception reason) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(6);
                os.writeShort(this.invId);
                if (EJBServerChannel.this.version >= 3) {
                    os.writeByte(this.getEnlistmentStatus());
                }
                Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)os)));
                marshaller.writeObject((Object)reason);
                marshaller.writeByte(0);
                marshaller.finish();
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB response write failed", e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }
    }

    class ReceiverImpl
    implements Channel.Receiver {
        private final Association association;
        private final ListenerHandle handle1;
        private final ListenerHandle handle2;

        ReceiverImpl(Association association, ListenerHandle handle1, ListenerHandle handle2) {
            this.association = association;
            this.handle1 = handle1;
            this.handle2 = handle2;
        }

        public void handleError(Channel channel, IOException error) {
            this.handle1.close();
            this.handle2.close();
        }

        public void handleEnd(Channel channel) {
            this.handle1.close();
            this.handle2.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void handleMessage(Channel channel, MessageInputStream message) {
            try {
                code = message.readUnsignedByte();
                switch (code) {
                    case 3: 
                    case 27: {
                        input = code == 27 ? new InflaterInputStream((InputStream)message) : message;
                        var5_10 = null;
                        if (code == 27 && (verify = input.read()) != 3) {
                            throw new RuntimeException();
                        }
                        invId = input.read() << 8 | input.read();
                        try {
                            this.handleInvocationRequest(invId, input);
                        }
                        catch (IOException | ClassNotFoundException e) {
                            EJBServerChannel.access$000(EJBServerChannel.this, invId, e);
                        }
                        if (input == null) break;
                        if (var5_10 == null) ** GOTO lbl26
                        try {
                            input.close();
                            ** break;
lbl21:
                            // 1 sources

                        }
                        catch (Throwable var6_16) {
                            var5_10.addSuppressed(var6_16);
                            ** break;
                        }
lbl25:
                        // 1 sources

                        break;
lbl26:
                        // 1 sources

                        input.close();
                        ** break;
lbl28:
                        // 1 sources

                        break;
                        catch (Throwable var6_17) {
                            try {
                                var5_10 = var6_17;
                                throw var6_17;
                            }
                            catch (Throwable var8_19) {
                                if (input != null) {
                                    if (var5_10 != null) {
                                        try {
                                            input.close();
                                        }
                                        catch (Throwable var9_20) {
                                            var5_10.addSuppressed(var9_20);
                                        }
                                    } else {
                                        input.close();
                                    }
                                }
                                throw var8_19;
                            }
                        }
                    }
                    case 1: {
                        invId = message.readUnsignedShort();
                        try {
                            this.handleSessionOpenRequest(invId, message);
                            ** break;
lbl49:
                            // 1 sources

                        }
                        catch (IOException e) {
                            EJBServerChannel.access$000(EJBServerChannel.this, invId, e);
                            ** break;
                        }
lbl53:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        invId = message.readUnsignedShort();
                        try {
                            this.handleCancelRequest(invId, message);
                            ** break;
lbl59:
                            // 1 sources

                        }
                        catch (IOException var5_12) {
                            ** break;
                        }
lbl62:
                        // 1 sources

                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        invId = message.readUnsignedShort();
                        try {
                            this.handleTxnRequest(code, invId, message);
                            ** break;
lbl68:
                            // 1 sources

                        }
                        catch (IOException var5_13) {
                            ** break;
                        }
lbl71:
                        // 1 sources

                        break;
                    }
                    case 25: {
                        invId = message.readUnsignedShort();
                        try {
                            this.handleTxnRecoverRequest(invId, message);
                            ** break;
lbl77:
                            // 1 sources

                        }
                        catch (IOException var5_14) {
                            ** break;
                        }
lbl80:
                        // 1 sources

                        break;
                    }
                    default: {
                        Logs.REMOTING.invalidMessageReceived(code);
                        break;
                    }
                }
            }
            catch (IOException var3_4) {
            }
            finally {
                IoUtils.safeClose((Closeable)message);
                channel.receiveMessage((Channel.Receiver)this);
            }
        }

        private void writeTxnResponse(int invId, int flag) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(20);
                os.writeShort(invId);
                os.writeBoolean(true);
                PackedInteger.writePackedInteger((DataOutput)os, flag);
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB transaction response write failed", e);
            }
        }

        private void writeTxnResponse(int invId) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(20);
                os.writeShort(invId);
                os.writeBoolean(false);
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB transaction response write failed", e);
            }
        }

        private void handleTxnRequest(int code, int invId, MessageInputStream message) throws IOException {
            byte[] bytes = new byte[message.readUnsignedShort()];
            message.readFully(bytes);
            TransactionID transactionID = TransactionID.createTransactionID(bytes);
            if (transactionID instanceof XidTransactionID) {
                try {
                    SubordinateTransactionControl control = EJBServerChannel.this.transactionServer.getTransactionService().getTransactionContext().findOrImportTransaction(((XidTransactionID)transactionID).getXid(), 0).getControl();
                    switch (code) {
                        case 15: {
                            boolean opc = message.readBoolean();
                            control.commit(opc);
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 16: {
                            control.rollback();
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 17: {
                            int res = control.prepare();
                            this.writeTxnResponse(invId, res);
                            break;
                        }
                        case 18: {
                            control.forget();
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 19: {
                            control.beforeCompletion();
                            this.writeTxnResponse(invId);
                            break;
                        }
                        default: {
                            throw Assert.impossibleSwitchCase((int)code);
                        }
                    }
                }
                catch (XAException e) {
                    EJBServerChannel.this.writeFailedResponse(invId, e);
                }
            } else if (transactionID instanceof UserTransactionID) {
                try {
                    LocalTransaction localTransaction = EJBServerChannel.this.transactionServer.getTransactionIfExists(((UserTransactionID)transactionID).getId());
                    switch (code) {
                        case 15: {
                            if (localTransaction != null) {
                                localTransaction.commit();
                            }
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 16: {
                            if (localTransaction != null) {
                                localTransaction.rollback();
                            }
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 17: 
                        case 18: 
                        case 19: {
                            EJBServerChannel.this.writeFailedResponse(invId, Logs.TXN.userTxNotSupportedByTxContext());
                            break;
                        }
                        default: {
                            throw Assert.impossibleSwitchCase((int)code);
                        }
                    }
                }
                catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
                    EJBServerChannel.this.writeFailedResponse(invId, (Exception)e);
                }
            } else {
                throw Assert.unreachableCode();
            }
        }

        void handleTxnRecoverRequest(int invId, MessageInputStream message) throws IOException {
            Xid[] xids;
            String parentName = message.readUTF();
            int flags = message.readInt();
            try {
                xids = EJBServerChannel.this.transactionServer.getTransactionService().getTransactionContext().getRecoveryInterface().recover(flags, parentName);
            }
            catch (XAException e) {
                EJBServerChannel.this.writeFailedResponse(invId, e);
                return;
            }
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(26);
                os.writeShort(invId);
                PackedInteger.writePackedInteger((DataOutput)os, xids.length);
                Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)os)));
                for (Xid xid : xids) {
                    marshaller.writeObject((Object)new XidTransactionID(xid));
                }
                marshaller.finish();
            }
            catch (IOException e) {
                Logs.REMOTING.trace("EJB transaction response write failed", e);
            }
        }

        void handleCancelRequest(int invId, MessageInputStream message) throws IOException {
            boolean cancelIfRunning = EJBServerChannel.this.version < 3 || message.readBoolean();
            InProgress inProgress = (InProgress)EJBServerChannel.this.invocations.get(invId);
            if (inProgress != null) {
                inProgress.getCancelHandle().cancel(cancelIfRunning);
            }
        }

        void handleSessionOpenRequest(int invId, MessageInputStream inputStream) throws IOException {
            ExceptionSupplier<ImportResult<?>, SystemException> transactionSupplier;
            int securityContext;
            String appName = inputStream.readUTF();
            String moduleName = inputStream.readUTF();
            String distName = inputStream.readUTF();
            String beanName = inputStream.readUTF();
            if (EJBServerChannel.this.version >= 3) {
                securityContext = inputStream.readInt();
                transactionSupplier = EJBServerChannel.this.readTransaction((DataInput)inputStream);
            } else {
                securityContext = 0;
                transactionSupplier = null;
            }
            Connection connection = EJBServerChannel.this.channel.getConnection();
            EJBIdentifier identifier = new EJBIdentifier(appName, moduleName, beanName, distName);
            this.association.receiveSessionOpenRequest(new RemotingSessionOpenRequest(invId, identifier, transactionSupplier, connection.getLocalIdentity(securityContext)));
        }

        void handleInvocationRequest(int invId, InputStream input) throws IOException, ClassNotFoundException {
            SecurityIdentity identity;
            EJBMethodLocator methodLocator;
            EJBIdentifier identifier;
            Unmarshaller unmarshaller;
            MarshallingConfiguration configuration = EJBServerChannel.this.configuration.clone();
            ServerClassResolver classResolver = new ServerClassResolver();
            configuration.setClassResolver((ClassResolver)classResolver);
            Connection connection = EJBServerChannel.this.channel.getConnection();
            if (EJBServerChannel.this.version >= 3) {
                unmarshaller = EJBServerChannel.this.marshallerFactory.createUnmarshaller(configuration);
                unmarshaller.start(Marshalling.createByteInput((InputStream)input));
                identifier = (EJBIdentifier)unmarshaller.readObject(EJBIdentifier.class);
                methodLocator = (EJBMethodLocator)unmarshaller.readObject(EJBMethodLocator.class);
                int identityId = unmarshaller.readInt();
                identity = identityId == 0 ? connection.getLocalIdentity() : connection.getLocalIdentity(identityId);
            } else {
                assert (EJBServerChannel.this.version <= 2);
                DataInputStream data = new DataInputStream(input);
                String methodName = data.readUTF();
                String sigString = data.readUTF();
                unmarshaller = EJBServerChannel.this.marshallerFactory.createUnmarshaller(configuration);
                unmarshaller.start(Marshalling.createByteInput((InputStream)data));
                String appName = (String)unmarshaller.readObject(String.class);
                String moduleName = (String)unmarshaller.readObject(String.class);
                String distinctName = (String)unmarshaller.readObject(String.class);
                String beanName = (String)unmarshaller.readObject(String.class);
                identifier = new EJBIdentifier(appName, moduleName, beanName, distinctName);
                String[] parameterTypeNames = sigString.isEmpty() ? new String[]{} : sigString.split(String.valueOf(','));
                methodLocator = new EJBMethodLocator(methodName, parameterTypeNames);
                identity = connection.getLocalIdentity();
            }
            RemotingInvocationRequest request = new RemotingInvocationRequest(invId, connection, this.association, identifier, methodLocator, classResolver, unmarshaller, identity);
            EJBServerChannel.this.invocations.put((Object)new InProgress(request, this.association.receiveInvocationRequest(request)));
        }
    }
}

